/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Identifiable;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.ResourceNameResolver;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactImpl;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.data.AttributeTypes;

public class AttributeResourceNameResolver
implements ResourceNameResolver {
    private static final int MAX_NAME_SIZE = 60;
    private final Attribute<?> attribute;
    private final AttributeTypes attributeTypeCache;

    public AttributeResourceNameResolver(AttributeTypes attributeTypeCache, Attribute<?> attribute) {
        this.attributeTypeCache = attributeTypeCache;
        this.attribute = attribute;
    }

    @Override
    public String getStorageName() throws OseeCoreException {
        Identifiable<String> identity = this.attribute.getContainer();
        String guid = (String)identity.getGuid();
        Conditions.checkExpressionFailOnTrue((!GUID.isValid((String)guid) ? 1 : 0) != 0, (String)"Artifact has an invalid guid [%s]", (Object[])new Object[]{guid});
        return guid;
    }

    @Override
    public String getInternalFileName() throws OseeCoreException {
        Identifiable<String> identity = this.attribute.getContainer();
        StringBuilder builder = new StringBuilder();
        try {
            String name = identity.getName();
            if (name.length() > 60) {
                name = name.substring(0, 60);
            }
            builder.append(URLEncoder.encode(name, "UTF-8"));
            builder.append(".");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        builder.append(this.getStorageName());
        String fileTypeExtension = null;
        if (identity instanceof ArtifactImpl) {
            fileTypeExtension = ((ArtifactImpl)identity).getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Extension, null);
        }
        if (!Strings.isValid(fileTypeExtension)) {
            fileTypeExtension = this.getExtension(this.attribute);
        }
        if (Strings.isValid(fileTypeExtension)) {
            builder.append(".");
            builder.append(fileTypeExtension);
        }
        return builder.toString();
    }

    private String getExtension(Attribute<?> attribute) throws OseeCoreException {
        AttributeTypeToken attributeType = attribute.getAttributeType();
        String fileTypeExtension = null;
        if (attribute.isOfType((AttributeTypeId)CoreAttributeTypes.NativeContent)) {
            fileTypeExtension = (String)attribute.getValue();
        }
        if (!Strings.isValid(fileTypeExtension)) {
            fileTypeExtension = this.attributeTypeCache.getFileTypeExtension((AttributeTypeId)attributeType);
        }
        return fileTypeExtension;
    }
}

