/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleAttributesExist;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.HasOrcsData;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeCollection;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeExceptionFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeManager;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeSetHelper;
import org.eclipse.osee.orcs.core.internal.attribute.FromStringAttributeSetHelper;
import org.eclipse.osee.orcs.core.internal.attribute.TypedValueAttributeSetHelper;
import org.eclipse.osee.orcs.core.internal.util.MultiplicityState;
import org.eclipse.osee.orcs.core.internal.util.OrcsPredicates;

public abstract class AttributeManagerImpl
extends BaseId
implements HasOrcsData<ArtifactData>,
AttributeManager,
AttributeExceptionFactory {
    private final AttributeCollection attributes;
    private final String guid;
    private boolean isLoaded;
    private final AttributeFactory attributeFactory;

    protected AttributeManagerImpl(ArtifactData artifactData, AttributeFactory attributeFactory) {
        super(artifactData.getId());
        this.attributeFactory = attributeFactory;
        this.attributes = new AttributeCollection(this);
        this.guid = (String)artifactData.getGuid();
    }

    protected Collection<Attribute<?>> getAllAttributes() {
        return this.attributes.getAll();
    }

    @Override
    public synchronized void add(AttributeTypeId attributeType, Attribute<? extends Object> attribute) {
        this.attributes.add(attributeType, attribute);
        ((AttributeData)attribute.getOrcsData()).setArtifactId(this.getId().intValue());
    }

    @Override
    public synchronized void remove(AttributeTypeId type, Attribute<? extends Object> attribute) {
        this.attributes.remove(type, attribute);
        ((AttributeData)attribute.getOrcsData()).setArtifactId(-1);
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void setLoaded(boolean value) throws OseeCoreException {
        this.isLoaded = value;
        if (value) {
            this.onLoaded();
        }
    }

    @Override
    public void setAttributesNotDirty() {
        for (Attribute<?> attribute : this.getAllAttributes()) {
            attribute.clearDirty();
        }
    }

    @Override
    public boolean areAttributesDirty() {
        return this.attributes.hasDirty();
    }

    public String getName() {
        String name;
        try {
            name = this.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.Name);
        }
        catch (Exception ex) {
            name = Lib.exceptionToString((Exception)ex);
        }
        return name;
    }

    @Override
    public int getMaximumAttributeTypeAllowed(AttributeTypeId attributeType) throws OseeCoreException {
        int result = -1;
        if (this.isAttributeTypeValid(attributeType)) {
            result = this.attributeFactory.getMaxOccurrenceLimit(attributeType);
        }
        return result;
    }

    @Override
    public int getMinimumAttributeTypeAllowed(AttributeTypeId attributeType) throws OseeCoreException {
        int result = -1;
        if (this.isAttributeTypeValid(attributeType)) {
            result = this.attributeFactory.getMinOccurrenceLimit(attributeType);
        }
        return result;
    }

    @Override
    public Collection<AttributeTypeToken> getExistingAttributeTypes() throws OseeCoreException {
        this.ensureAttributesLoaded();
        return this.attributes.getExistingTypes(DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public int getAttributeCount(AttributeTypeId attributeType) throws OseeCoreException {
        return this.getAttributesExcludeDeleted(attributeType).size();
    }

    @Override
    public Attribute<Object> getAttributeById(Integer attributeId) throws OseeCoreException {
        return this.getAttributeById(attributeId, DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public Attribute<Object> getAttributeById(Integer attributeId, DeletionFlag includeDeleted) throws OseeCoreException {
        Attribute attribute = null;
        Optional tryFind = Iterables.tryFind(this.getAttributes(includeDeleted), OrcsPredicates.attributeId(attributeId));
        if (!tryFind.isPresent()) {
            throw new AttributeDoesNotExist("Attribute[%s] does not exist for %s", new Object[]{attributeId, this.getExceptionString()});
        }
        attribute = (Attribute)tryFind.get();
        return attribute;
    }

    @Override
    public List<Attribute<Object>> getAttributes() throws OseeCoreException {
        return this.getAttributesExcludeDeleted();
    }

    @Override
    public <T> List<Attribute<T>> getAttributes(AttributeTypeId attributeType) throws OseeCoreException {
        return this.getAttributesExcludeDeleted(attributeType);
    }

    @Override
    public <T> List<T> getAttributeValues(AttributeTypeId attributeType) throws OseeCoreException {
        List<Attribute<T>> attributes = this.getAttributesExcludeDeleted(attributeType);
        LinkedList<Object> values = new LinkedList<Object>();
        for (Attribute<T> attribute : attributes) {
            Object value = attribute.getValue();
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public int getAttributeCount(AttributeTypeId attributeType, DeletionFlag includeDeleted) throws OseeCoreException {
        return this.getAttributesHelper(attributeType, includeDeleted).size();
    }

    @Override
    public List<Attribute<Object>> getAttributes(DeletionFlag includeDeleted) throws OseeCoreException {
        return this.getAttributesHelper(includeDeleted);
    }

    @Override
    public <T> List<Attribute<T>> getAttributes(AttributeTypeId attributeType, DeletionFlag includeDeleted) throws OseeCoreException {
        return this.getAttributesHelper(attributeType, includeDeleted);
    }

    @Override
    public String getSoleAttributeAsString(AttributeTypeId attributeType, String defaultValue) throws OseeCoreException {
        String toReturn = defaultValue;
        List items = this.getAttributesExcludeDeleted(attributeType);
        if (!items.isEmpty()) {
            Attribute firstItem = items.iterator().next();
            toReturn = String.valueOf(firstItem.getValue());
        }
        return toReturn;
    }

    @Override
    public String getSoleAttributeAsString(AttributeTypeId attributeType) throws OseeCoreException {
        String toReturn = null;
        Object value = this.getSoleAttributeValue(attributeType);
        if (value instanceof InputStream) {
            InputStream inputStream = (InputStream)value;
            try {
                try {
                    toReturn = Lib.inputStreamToString((InputStream)inputStream);
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex2) {
                        OseeCoreException.wrapAndThrow((Throwable)ex2);
                    }
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
        } else if (value != null) {
            toReturn = value.toString();
        }
        return toReturn;
    }

    @Override
    public <T> T getSoleAttributeValue(AttributeTypeId attributeType) {
        Attribute<T> attribute = this.getSoleAttribute(attributeType);
        return (T)attribute.getValue();
    }

    @Override
    public <T> T getSoleAttributeValue(AttributeTypeId attributeType, DeletionFlag flag, T defaultValue) {
        Object value = defaultValue;
        Attribute<T> attribute = null;
        try {
            attribute = this.getSoleAttribute(attributeType, flag);
            value = attribute.getValue();
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {}
        return value;
    }

    @Override
    public <T> T getSoleAttributeValue(AttributeTypeId attributeType, T defaultValue) throws OseeCoreException {
        Object value = defaultValue;
        Attribute<T> attribute = null;
        try {
            attribute = this.getSoleAttribute(attributeType);
            value = attribute.getValue();
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {}
        return value;
    }

    @Override
    public <T> void setSoleAttributeValue(AttributeTypeId attributeType, T value) throws OseeCoreException {
        Attribute<T> attribute = this.getOrCreateSoleAttribute(attributeType);
        attribute.setValue(value);
    }

    @Override
    public void setSoleAttributeFromString(AttributeTypeId attributeType, String value) throws OseeCoreException {
        this.getOrCreateSoleAttribute(attributeType).setFromString(value);
    }

    @Override
    public void setSoleAttributeFromStream(AttributeTypeId attributeType, InputStream inputStream) throws OseeCoreException {
        this.getOrCreateSoleAttribute(attributeType).setValueFromInputStream(inputStream);
    }

    @Override
    public void setAttributesFromStrings(AttributeTypeId attributeType, String ... values) throws OseeCoreException {
        this.setAttributesFromStrings(attributeType, Arrays.asList(values));
    }

    @Override
    public void setAttributesFromStrings(AttributeTypeId attributeType, Collection<String> values) throws OseeCoreException {
        FromStringAttributeSetHelper attributeStringSetter = new FromStringAttributeSetHelper(this.attributes, this);
        this.setAttributesFromValuesHelper(attributeStringSetter, attributeType, values);
    }

    @Override
    public <T> void setAttributesFromValues(AttributeTypeId attributeType, T ... values) throws OseeCoreException {
        this.setAttributesFromValues(attributeType, (Collection<T>)Arrays.asList(values));
    }

    @Override
    public <T> void setAttributesFromValues(AttributeTypeId attributeType, Collection<T> values) throws OseeCoreException {
        TypedValueAttributeSetHelper setter = new TypedValueAttributeSetHelper(this.attributes, this);
        this.setAttributesFromValuesHelper(setter, attributeType, values);
    }

    @Override
    public void deleteAttributesByArtifact() throws OseeCoreException {
        for (Attribute<Object> attribute : this.getAttributesIncludeDeleted()) {
            attribute.setArtifactDeleted();
        }
    }

    @Override
    public void unDeleteAttributesByArtifact() throws OseeCoreException {
        for (Attribute<Object> attribute : this.getAttributesIncludeDeleted()) {
            if (ModificationType.ARTIFACT_DELETED != attribute.getModificationType()) continue;
            attribute.unDelete();
        }
    }

    @Override
    public void deleteSoleAttribute(AttributeTypeId attributeType) throws OseeCoreException {
        Attribute attribute = this.getSoleAttribute(attributeType);
        if (attribute != null) {
            this.deleteAttribute(attribute);
        }
    }

    @Override
    public void deleteAttributes(AttributeTypeId attributeType) throws OseeCoreException {
        for (Attribute attribute : this.getAttributesIncludeDeleted(attributeType)) {
            attribute.delete();
        }
    }

    @Override
    public void deleteAttributesWithValue(AttributeTypeId attributeType, Object value) throws OseeCoreException {
        for (Attribute attribute : this.getAttributesIncludeDeleted(attributeType)) {
            if (!attribute.getValue().equals(value)) continue;
            this.deleteAttribute(attribute);
            break;
        }
    }

    private void deleteAttribute(Attribute<?> attribute) throws OseeCoreException {
        this.checkMultiplicityCanDelete((AttributeTypeId)attribute.getAttributeType());
        attribute.delete();
    }

    @Override
    public <T> Attribute<T> createAttribute(AttributeTypeId attributeType) throws OseeCoreException {
        return this.internalCreateAttributeHelper(attributeType);
    }

    @Override
    public <T> Attribute<T> createAttribute(AttributeTypeId attributeType, T value) throws OseeCoreException {
        Attribute<T> attribute = this.internalCreateAttributeHelper(attributeType);
        attribute.setValue(value);
        return attribute;
    }

    @Override
    public <T> Attribute<T> createAttributeFromString(AttributeTypeId attributeType, String value) throws OseeCoreException {
        Attribute<T> attribute = this.internalCreateAttributeHelper(attributeType);
        attribute.setFromString(value);
        return attribute;
    }

    private <T> Attribute<T> internalCreateAttributeHelper(AttributeTypeId attributeType) throws OseeCoreException {
        this.checkTypeValid(attributeType);
        this.checkMultiplicityCanAdd(attributeType);
        Attribute attr = this.attributeFactory.createAttributeWithDefaults(this, (ArtifactData)this.getOrcsData(), attributeType);
        this.add(attributeType, attr);
        return attr;
    }

    private <T> Attribute<T> getOrCreateSoleAttribute(AttributeTypeId attributeType) throws OseeCoreException {
        ResultSet result = this.attributes.getResultSet(attributeType, DeletionFlag.EXCLUDE_DELETED);
        Attribute<T> attribute = (Attribute<T>)result.getAtMostOneOrNull();
        if (attribute == null) {
            attribute = this.internalCreateAttributeHelper(attributeType);
        }
        return attribute;
    }

    @Override
    public <T> Attribute<T> getSoleAttribute(AttributeTypeId attributeType) {
        return this.getSoleAttribute(attributeType, DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public <T> Attribute<T> getSoleAttribute(AttributeTypeId attributeType, DeletionFlag flag) {
        this.ensureAttributesLoaded();
        ResultSet result = this.attributes.getResultSet(attributeType, flag);
        return (Attribute)result.getExactlyOne();
    }

    private List<Attribute<Object>> getAttributesExcludeDeleted() throws OseeCoreException {
        return this.getAttributesHelper(DeletionFlag.EXCLUDE_DELETED);
    }

    private List<Attribute<Object>> getAttributesIncludeDeleted() throws OseeCoreException {
        return this.getAttributesHelper(DeletionFlag.INCLUDE_DELETED);
    }

    private <T> List<Attribute<T>> getAttributesExcludeDeleted(AttributeTypeId attributeType) throws OseeCoreException {
        return this.getAttributesHelper(attributeType, DeletionFlag.EXCLUDE_DELETED);
    }

    private <T> List<Attribute<T>> getAttributesIncludeDeleted(AttributeTypeId attributeType) throws OseeCoreException {
        return this.getAttributesHelper(attributeType, DeletionFlag.INCLUDE_DELETED);
    }

    private List<Attribute<Object>> getAttributesHelper(DeletionFlag includeDeleted) throws OseeCoreException {
        this.ensureAttributesLoaded();
        return Collections.castAll(this.attributes.getList(includeDeleted));
    }

    private <T> List<Attribute<T>> getAttributesHelper(AttributeTypeId attributeType, DeletionFlag includeDeleted) throws OseeCoreException {
        this.ensureAttributesLoaded();
        return this.attributes.getList(attributeType, includeDeleted);
    }

    private <A, T> void setAttributesFromValuesHelper(AttributeSetHelper<A, T> helper, AttributeTypeId attributeType, Collection<T> values) throws OseeCoreException {
        this.ensureAttributesLoaded();
        LinkedHashSet<T> uniqueItems = new LinkedHashSet<T>(values);
        List<Attribute<T>> remainingAttributes = this.getAttributesExcludeDeleted(attributeType);
        ArrayList remainingNewValues = new ArrayList(uniqueItems.size());
        for (Object e : uniqueItems) {
            boolean found = false;
            for (Attribute<T> attribute : remainingAttributes) {
                if (!helper.matches(attribute, e)) continue;
                remainingAttributes.remove(attribute);
                found = true;
                break;
            }
            if (found) continue;
            remainingNewValues.add(e);
        }
        for (Object e : remainingNewValues) {
            Attribute<T> attribute;
            if (remainingAttributes.isEmpty()) {
                helper.createAttribute(attributeType, e);
                continue;
            }
            int index = remainingAttributes.size() - 1;
            attribute = remainingAttributes.get(index);
            helper.setAttributeValue(attribute, e);
            remainingAttributes.remove(index);
        }
        for (Attribute attribute : remainingAttributes) {
            attribute.delete();
        }
    }

    private void checkTypeValid(AttributeTypeId attributeType) throws OseeCoreException {
        if (!CoreAttributeTypes.Name.equals(attributeType) && !this.isAttributeTypeValid(attributeType)) {
            throw new OseeArgumentException("The attribute type [%s] is not valid for artifacts [%s]", new Object[]{attributeType, this.getExceptionString()});
        }
    }

    private void checkMultiplicityCanAdd(AttributeTypeId attributeType) throws OseeCoreException {
        this.checkMultiplicity(attributeType, this.getAttributeCount(attributeType) + 1);
    }

    private void checkMultiplicityCanDelete(AttributeTypeId attributeType) throws OseeCoreException {
        this.checkMultiplicity(attributeType, this.getAttributeCount(attributeType) - 1);
    }

    private void checkMultiplicity(AttributeTypeId attributeType, int count) throws OseeCoreException {
        MultiplicityState state = this.getAttributeMuliplicityState(attributeType, count);
        switch (state) {
            case MAX_VIOLATION: {
                throw new OseeStateException("Attribute type [%s] exceeds max occurrence rule on [%s]", new Object[]{attributeType, this.getExceptionString()});
            }
            case MIN_VIOLATION: {
                throw new OseeStateException("Attribute type [%s] is less than min occurrence rule on [%s]", new Object[]{attributeType, this.getExceptionString()});
            }
        }
    }

    private MultiplicityState getAttributeMuliplicityState(AttributeTypeId attributeType, int count) throws OseeCoreException {
        MultiplicityState state = MultiplicityState.IS_VALID;
        if (count > this.attributeFactory.getMaxOccurrenceLimit(attributeType)) {
            state = MultiplicityState.MAX_VIOLATION;
        } else if (count < this.attributeFactory.getMinOccurrenceLimit(attributeType)) {
            state = MultiplicityState.MIN_VIOLATION;
        }
        return state;
    }

    private void onLoaded() throws OseeCoreException {
        this.meetMinimumAttributes();
    }

    private void ensureAttributesLoaded() {
    }

    private void meetMinimumAttributes() throws OseeCoreException {
        for (AttributeTypeId attributeType : this.getValidAttributeTypes()) {
            int missingCount = this.getRemainingAttributeCount(attributeType);
            int i = 0;
            while (i < missingCount) {
                Attribute attr = this.attributeFactory.createAttributeWithDefaults(this, (ArtifactData)this.getOrcsData(), attributeType);
                this.add(attributeType, attr);
                attr.clearDirty();
                ++i;
            }
        }
    }

    private final int getRemainingAttributeCount(AttributeTypeId attributeType) throws OseeCoreException {
        int minLimit = this.attributeFactory.getMinOccurrenceLimit(attributeType);
        return minLimit - this.getAttributeCount(attributeType);
    }

    @Override
    public MultipleAttributesExist createManyExistException(AttributeTypeId type, int count) {
        MultipleAttributesExist toReturn = type != null ? new MultipleAttributesExist("The attribute type [%s] has [%s] instances on [%s], but only [1] instance is allowed", new Object[]{type, count, this.getExceptionString()}) : new MultipleAttributesExist("Multiple items found - total instances [%s] on [%s], but only [1] instance is allowed", new Object[]{count, this.getExceptionString()});
        return toReturn;
    }

    @Override
    public AttributeDoesNotExist createDoesNotExistException(AttributeTypeId type) {
        AttributeDoesNotExist toReturn = type == null ? new AttributeDoesNotExist("Attribute could not be found on [%s]", new Object[]{this.getExceptionString()}) : new AttributeDoesNotExist("Attribute of type [%s] could not be found on [%s]", new Object[]{type, this.getExceptionString()});
        return toReturn;
    }

    public String getGuid() {
        return this.guid;
    }
}

