/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import java.lang.ref.WeakReference;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.AttributeDataFactory;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.ResourceNameResolver;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeClassResolver;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeContainer;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeManager;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeResourceNameResolver;
import org.eclipse.osee.orcs.data.AttributeTypes;

public class AttributeFactory {
    private final AttributeClassResolver classResolver;
    private final AttributeDataFactory dataFactory;
    private final AttributeTypes cache;

    public AttributeFactory(AttributeClassResolver classResolver, AttributeDataFactory dataFactory, AttributeTypes cache) {
        this.classResolver = classResolver;
        this.dataFactory = dataFactory;
        this.cache = cache;
    }

    public <T> Attribute<T> createAttributeWithDefaults(AttributeContainer container, ArtifactData artifactData, AttributeTypeId attributeType) throws OseeCoreException {
        AttributeData data = this.dataFactory.create(artifactData, attributeType);
        return this.createAttribute(container, data, true, true);
    }

    public <T> Attribute<T> createAttribute(AttributeContainer container, AttributeData data) throws OseeCoreException {
        return this.createAttribute(container, data, false, false);
    }

    private <T> Attribute<T> createAttribute(AttributeContainer container, AttributeData data, boolean isDirty, boolean createWithDefaults) throws OseeCoreException {
        AttributeTypeId type = (AttributeTypeId)this.cache.get(Long.valueOf(data.getTypeUuid()));
        Conditions.checkNotNull((Object)type, (String)"attributeType", (String)"Cannot find attribute type with uuid[%s]", (Object[])new Object[]{data.getTypeUuid()});
        Attribute attribute = this.classResolver.createAttribute(type);
        DataProxy proxy = data.getDataProxy();
        ResourceNameResolver resolver = this.createResolver(attribute);
        proxy.setResolver(resolver);
        WeakReference<AttributeContainer> artifactRef = new WeakReference<AttributeContainer>(container);
        attribute.internalInitialize(this.cache, artifactRef, data, isDirty, createWithDefaults);
        container.add(type, attribute);
        return attribute;
    }

    public <T> Attribute<T> copyAttribute(AttributeData source, BranchId ontoBranch, AttributeContainer destinationContainer) throws OseeCoreException {
        AttributeData attributeData = this.dataFactory.copy(ontoBranch, source);
        return this.createAttribute(destinationContainer, attributeData, true, false);
    }

    public <T> Attribute<T> cloneAttribute(AttributeData source, AttributeContainer destinationContainer) throws OseeCoreException {
        AttributeData attributeData = this.dataFactory.clone(source);
        Attribute<T> destinationAttribute = this.createAttribute(destinationContainer, attributeData, false, false);
        return destinationAttribute;
    }

    public <T> Attribute<Object> introduceAttribute(AttributeData source, BranchId ontoBranch, AttributeManager destination) throws OseeCoreException {
        AttributeData attributeData = this.dataFactory.introduce(ontoBranch, source);
        Attribute<Object> destinationAttribute = null;
        if (source.getVersion().isInStorage()) {
            try {
                destinationAttribute = destination.getAttributeById(source.getLocalId(), DeletionFlag.INCLUDE_DELETED);
                WeakReference<AttributeContainer> artifactRef = new WeakReference<AttributeContainer>(destination);
                destinationAttribute.internalInitialize(this.cache, artifactRef, attributeData, true, false);
            }
            catch (AttributeDoesNotExist attributeDoesNotExist) {
                destinationAttribute = this.createAttribute(destination, attributeData);
            }
        }
        return destinationAttribute;
    }

    private ResourceNameResolver createResolver(Attribute<?> attribute) {
        return new AttributeResourceNameResolver(this.cache, attribute);
    }

    public int getMaxOccurrenceLimit(AttributeTypeId attributeType) throws OseeCoreException {
        return this.cache.getMaxOccurrences(attributeType);
    }

    public int getMinOccurrenceLimit(AttributeTypeId attributeType) throws OseeCoreException {
        return this.cache.getMinOccurrences(attributeType);
    }
}

