/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeExceptionFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeResultSet;
import org.eclipse.osee.orcs.core.internal.util.AbstractTypeCollection;
import org.eclipse.osee.orcs.core.internal.util.OrcsPredicates;

public class AttributeCollection
extends AbstractTypeCollection<AttributeTypeToken, Attribute<?>, AttributeTypeId, Attribute<?>> {
    private final AttributeExceptionFactory exceptionFactory;

    public AttributeCollection(AttributeExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
    }

    @Override
    protected ResultSet<Attribute<?>> createResultSet(List<Attribute<?>> values) {
        return new AttributeResultSet(this.exceptionFactory, values);
    }

    @Override
    protected <T extends Attribute<?>> ResultSet<T> createResultSet(AttributeTypeId attributeType, List<T> values) {
        return new AttributeResultSet(this.exceptionFactory, attributeType, values);
    }

    @Override
    protected Attribute<?> asMatcherData(Attribute<?> data) {
        return data;
    }

    @Override
    protected AttributeTypeToken getType(Attribute<?> data) throws OseeCoreException {
        return data.getAttributeType();
    }

    public <T> ResultSet<Attribute<T>> getResultSet(AttributeTypeId attributeType, DeletionFlag includeDeleted) throws OseeCoreException {
        List<Attribute<T>> result = this.getList(attributeType, includeDeleted);
        return this.createResultSet(attributeType, result);
    }

    public <T> ResultSet<Attribute<T>> getAttributeSetFromString(AttributeTypeId attributeType, DeletionFlag includeDeleted, String value) throws OseeCoreException {
        Predicate deleteStateMatch = OrcsPredicates.deletionFlagEquals(includeDeleted);
        Predicate<Attribute<String>> stringEqualsMatch = OrcsPredicates.attributeStringEquals(value);
        Predicate filter = Predicates.and(deleteStateMatch, stringEqualsMatch);
        return this.getSetByFilter(attributeType, filter);
    }

    public <T> ResultSet<Attribute<T>> getAttributeSetFromValue(AttributeTypeId attributeType, DeletionFlag includeDeleted, T value) throws OseeCoreException {
        Predicate deleteStateMatch = OrcsPredicates.deletionFlagEquals(includeDeleted);
        Predicate<Attribute<T>> attributeValueEquals = OrcsPredicates.attributeValueEquals(value);
        Predicate filter = Predicates.and(attributeValueEquals, deleteStateMatch);
        return this.getSetByFilter(attributeType, filter);
    }

    public <T> List<Attribute<T>> getList(AttributeTypeId attributeType, DeletionFlag includeDeleted) throws OseeCoreException {
        Predicate attributeDeletionFlagEquals = OrcsPredicates.deletionFlagEquals(includeDeleted);
        return this.getListByFilter(attributeType, attributeDeletionFlagEquals);
    }
}

