/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeClassRegistry;
import org.eclipse.osee.orcs.data.AttributeTypes;

public class AttributeClassResolver {
    private final AttributeClassRegistry registry;
    private final AttributeTypes attributeTypes;

    public AttributeClassResolver(AttributeClassRegistry registry, AttributeTypes attributeTypes) {
        this.registry = registry;
        this.attributeTypes = attributeTypes;
    }

    public Class<? extends Attribute<?>> getBaseClazz(String alias) {
        return this.registry.getBaseClazz(alias);
    }

    protected Class<? extends Attribute<?>> getBaseClazz(AttributeTypeId attributeType) throws OseeCoreException {
        String alias = this.attributeTypes.getBaseAttributeTypeId(attributeType);
        if (alias.contains(".")) {
            alias = Lib.getExtension((String)alias);
        }
        return this.getBaseClazz(alias);
    }

    public boolean isBaseTypeCompatible(Class<? extends Attribute<?>> baseType, AttributeTypeId attributeType) throws OseeCoreException {
        Conditions.checkNotNull(baseType, (String)"baseType", (String)"Unable to determine base type from null", (Object[])new Object[0]);
        Conditions.checkNotNull((Object)attributeType, (String)"attributeType");
        Class<? extends Attribute<?>> clazz = this.getBaseClazz(attributeType);
        Conditions.checkNotNull(clazz, (String)"base attribute type class", (String)"Unable to find base attribute type class for [%s]", (Object[])new Object[]{attributeType});
        return baseType.isAssignableFrom(clazz);
    }

    public <T> Attribute<T> createAttribute(AttributeTypeId type) throws OseeCoreException {
        Class<? extends Attribute<?>> attributeClass = this.getAttributeClass(type);
        Conditions.checkNotNull(attributeClass, (String)"attributeClass", (String)"Cannot find attribute class base type for attributeType[%s]", (Object[])new Object[]{type});
        return this.createAttribute(attributeClass);
    }

    private Class<? extends Attribute<?>> getAttributeClass(AttributeTypeId type) throws OseeCoreException {
        Class<? extends Attribute<?>> attributeClass = this.getBaseClazz(type);
        if (attributeClass == null) {
            attributeClass = this.getBaseClazz("StringAttribute");
        }
        return attributeClass;
    }

    private <T> Attribute<T> createAttribute(Class<? extends Attribute<?>> attributeClass) throws OseeCoreException {
        try {
            return attributeClass.newInstance();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }
}

