/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.AttributeClassProvider;
import org.eclipse.osee.orcs.core.annotations.OseeAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;

public class AttributeClassRegistry {
    private final Map<String, Class<? extends Attribute<?>>> map = new ConcurrentHashMap();
    private Log logger;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start() {
    }

    public void stop() {
    }

    public void addProvider(AttributeClassProvider provider) {
        for (Class<? extends Attribute<?>> clazz : provider.getClasses()) {
            String alias = this.toAlias(clazz);
            this.map.put(alias, clazz);
        }
    }

    public void removeProvider(AttributeClassProvider provider) {
        for (Class<? extends Attribute<?>> clazz : provider.getClasses()) {
            String alias = this.toAlias(clazz);
            this.map.remove(alias);
        }
    }

    private String toAlias(Class<? extends Attribute<?>> clazz) {
        String toReturn;
        OseeAttribute annotation = clazz.getAnnotation(OseeAttribute.class);
        if (annotation != null) {
            toReturn = annotation.value();
        } else {
            toReturn = clazz.getSimpleName();
            this.logger.warn("Unable to find OseeAttribute annotation for [%s] - registering using clazz simple name [%s]", new Object[]{clazz, toReturn});
        }
        return toReturn;
    }

    public Class<? extends Attribute<?>> getBaseClazz(String alias) {
        return this.map.get(alias);
    }
}

