/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.artifact;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DirtyState;
import org.eclipse.osee.framework.core.enums.EditState;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactVisitor;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeManagerImpl;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderChange;
import org.eclipse.osee.orcs.data.ArtifactTypes;

public class ArtifactImpl
extends AttributeManagerImpl
implements Artifact {
    private final ArtifactTypes artifactTypeCache;
    private EditState objectEditState;
    private ArtifactData artifactData;
    private GraphData graph;

    public ArtifactImpl(ArtifactTypes artifactTypeCache, ArtifactData artifactData, AttributeFactory attributeFactory) {
        super(artifactData, attributeFactory);
        this.artifactTypeCache = artifactTypeCache;
        this.artifactData = artifactData;
        this.objectEditState = EditState.NO_CHANGE;
    }

    @Override
    public void setGraph(GraphData graph) {
        this.graph = graph;
    }

    @Override
    public GraphData getGraph() {
        return this.graph;
    }

    @Override
    public ArtifactData getOrcsData() {
        return this.artifactData;
    }

    @Override
    public void setOrcsData(ArtifactData data) {
        this.artifactData = data;
        this.objectEditState = EditState.NO_CHANGE;
    }

    public ModificationType getModificationType() {
        return this.getOrcsData().getModType();
    }

    public Integer getLocalId() {
        return (Integer)this.getOrcsData().getLocalId();
    }

    @Override
    public TransactionId getLastModifiedTransaction() {
        TransactionId maxTransactionId = this.getOrcsData().getVersion().getTransactionId();
        for (Attribute<?> attribute : this.getAllAttributes()) {
            TransactionId tx = ((AttributeData)attribute.getOrcsData()).getVersion().getTransactionId();
            if (!maxTransactionId.isOlderThan(tx)) continue;
            maxTransactionId = tx;
        }
        return maxTransactionId;
    }

    public TransactionId getTransaction() {
        return this.graph.getTransaction();
    }

    public BranchId getBranch() {
        return this.artifactData.getVersion().getBranch();
    }

    @Override
    public IArtifactType getArtifactType() throws OseeCoreException {
        return (IArtifactType)this.artifactTypeCache.get(Long.valueOf(this.getOrcsData().getTypeUuid()));
    }

    @Override
    public void setName(String name) throws OseeCoreException {
        this.setSoleAttributeFromString((AttributeTypeId)CoreAttributeTypes.Name, name);
    }

    @Override
    public void setArtifactType(IArtifactType artifactType) throws OseeCoreException {
        if (!this.getArtifactType().equals(artifactType)) {
            this.getOrcsData().setTypeUuid(artifactType.getGuid());
            this.objectEditState = EditState.ARTIFACT_TYPE_MODIFIED;
            if (this.getOrcsData().getVersion().isInStorage()) {
                this.getOrcsData().setModType(ModificationType.MODIFIED);
            }
        }
    }

    @Override
    public boolean isOfType(ArtifactTypeId ... otherTypes) throws OseeCoreException {
        return this.artifactTypeCache.inheritsFrom((ArtifactTypeId)this.getArtifactType(), otherTypes);
    }

    @Override
    public void setNotDirty() {
        this.setAttributesNotDirty();
        this.objectEditState = EditState.NO_CHANGE;
        this.getOrcsData().setModType(ModificationType.MODIFIED);
    }

    public boolean isDirty() {
        return this.areAttributesDirty() || this.hasDirtyArtifactType() || this.isReplaceWithVersion() || DirtyState.APPLICABILITY_ONLY == this.getOrcsData().getDirtyState();
    }

    private boolean isReplaceWithVersion() {
        return this.getModificationType() == ModificationType.REPLACED_WITH_VERSION || this.artifactData.isExistingVersionUsed();
    }

    private boolean hasDirtyArtifactType() {
        return this.objectEditState.isArtifactTypeChange();
    }

    @Override
    public boolean isAttributeTypeValid(AttributeTypeId attributeType) throws OseeCoreException {
        return this.artifactTypeCache.isValidAttributeType(this.getArtifactType(), this.getBranch(), attributeType);
    }

    @Override
    public Collection<AttributeTypeToken> getValidAttributeTypes() throws OseeCoreException {
        return this.artifactTypeCache.getAttributeTypes(this.getArtifactType(), this.getBranch());
    }

    @Override
    public String getExceptionString() {
        try {
            return String.format("artifact type[%s] guid[%s] on branch[%s]", this.getArtifactType(), this.getGuid(), this.getBranch());
        }
        catch (OseeCoreException ex) {
            return Lib.exceptionToString((Exception)((Object)ex));
        }
    }

    @Override
    public void accept(ArtifactVisitor visitor) throws OseeCoreException {
        visitor.visit(this);
        for (Attribute<?> attribute : this.getAllAttributes()) {
            visitor.visit(attribute);
        }
    }

    public void delete() throws OseeCoreException {
        this.getOrcsData().setModType(ModificationType.DELETED);
        this.deleteAttributesByArtifact();
    }

    public boolean isDeleteAllowed() {
        return !this.isDeleted();
    }

    public void unDelete() throws OseeCoreException {
        this.getOrcsData().setModType(this.getOrcsData().getBaseModType());
        this.unDeleteAttributesByArtifact();
    }

    @Override
    public boolean isAccessible() {
        return !this.isDeleted();
    }

    @Override
    public String getOrderData() throws OseeCoreException {
        return this.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.RelationOrder, Strings.emptyString());
    }

    @Override
    public void storeOrderData(OrderChange changeType, String data) throws OseeCoreException {
        if (Strings.isValid((String)data)) {
            this.setSoleAttributeFromString((AttributeTypeId)CoreAttributeTypes.RelationOrder, data);
        } else {
            this.deleteSoleAttribute((AttributeTypeId)CoreAttributeTypes.RelationOrder);
        }
    }

    @Override
    public String toString() {
        try {
            return String.format("artifact [type=[%s] guid=[%s] branch=[%s]]", this.getArtifactType(), this.getGuid(), this.getBranch());
        }
        catch (OseeCoreException ex) {
            return Lib.exceptionToString((Exception)((Object)ex));
        }
    }

    public Long getId() {
        return (long)this.getLocalId();
    }
}

