/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.artifact;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.ArtifactDataFactory;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactImpl;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeFactory;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class ArtifactFactory {
    private final ArtifactDataFactory factory;
    private final AttributeFactory attributeFactory;
    private final ArtifactTypes artifactTypeCache;

    public ArtifactFactory(ArtifactDataFactory factory, AttributeFactory attributeFactory, ArtifactTypes artifactTypeCache) {
        this.factory = factory;
        this.attributeFactory = attributeFactory;
        this.artifactTypeCache = artifactTypeCache;
    }

    public Artifact createArtifact(OrcsSession session, ArtifactData artifactData) throws OseeCoreException {
        return new ArtifactImpl(this.artifactTypeCache, artifactData, this.attributeFactory);
    }

    public Artifact createArtifact(OrcsSession session, BranchId branch, IArtifactType artifactType, String guid) throws OseeCoreException {
        ArtifactData artifactData = this.factory.create(branch, artifactType, guid);
        Artifact artifact = this.createArtifact(session, artifactData);
        artifact.setLoaded(true);
        return artifact;
    }

    public Artifact createArtifact(OrcsSession session, BranchId branch, IArtifactType artifactType, String guid, long uuid) throws OseeCoreException {
        ArtifactData artifactData = this.factory.create(branch, artifactType, guid, uuid);
        Artifact artifact = this.createArtifact(session, artifactData);
        artifact.setLoaded(true);
        return artifact;
    }

    public Artifact copyArtifact(OrcsSession session, Artifact source, Collection<? extends AttributeTypeId> types, BranchId ontoBranch) throws OseeCoreException {
        ArtifactData artifactData = this.factory.copy(ontoBranch, (ArtifactData)source.getOrcsData());
        Artifact copy = this.createArtifact(session, artifactData);
        Collection<AttributeTypeId> typesToCopy = this.getAllowedTypes(copy, types);
        for (AttributeTypeId attributeType : typesToCopy) {
            for (AttributeReadable attributeSource : source.getAttributes(attributeType)) {
                AttributeData data = this.getAttributeData(attributeSource);
                this.attributeFactory.copyAttribute(data, ontoBranch, copy);
            }
        }
        copy.setLoaded(true);
        return copy;
    }

    public Artifact introduceArtifact(OrcsSession session, Artifact source, Artifact destination, BranchId ontoBranch) throws OseeCoreException {
        destination = this.processIntroduceArtifact(session, source, destination, ontoBranch);
        this.processIntroduceAttributes(source, destination, ontoBranch);
        destination.setLoaded(true);
        return destination;
    }

    private void processIntroduceAttributes(Artifact source, Artifact destination, BranchId ontoBranch) {
        List introduceAttributes = source.getAttributes(DeletionFlag.INCLUDE_DELETED);
        this.removeAttributes(source, destination);
        for (Attribute attr : introduceAttributes) {
            if (!destination.isAttributeTypeValid((AttributeTypeId)attr.getAttributeType())) continue;
            this.attributeFactory.introduceAttribute((AttributeData)attr.getOrcsData(), ontoBranch, destination);
        }
    }

    private Artifact processIntroduceArtifact(OrcsSession session, Artifact source, Artifact destination, BranchId ontoBranch) {
        ArtifactData artifactData = this.factory.introduce(ontoBranch, (ArtifactData)source.getOrcsData());
        destination.setOrcsData(artifactData);
        return destination;
    }

    private void removeAttributes(Artifact introduce, Artifact destination) {
        for (Attribute destAttribute : destination.getAttributes(DeletionFlag.INCLUDE_DELETED)) {
            try {
                introduce.getAttributeById(destAttribute.getLocalId());
            }
            catch (AttributeDoesNotExist attributeDoesNotExist) {
                destAttribute.delete();
            }
        }
    }

    public Artifact clone(OrcsSession session, Artifact source) throws OseeCoreException {
        ArtifactData artifactData = this.factory.clone((ArtifactData)source.getOrcsData());
        Artifact copy = this.createArtifact(session, artifactData);
        for (AttributeTypeId attributeType : source.getExistingAttributeTypes()) {
            for (AttributeReadable attributeSource : source.getAttributes(attributeType)) {
                AttributeData data = this.getAttributeData(attributeSource);
                this.attributeFactory.cloneAttribute(data, copy);
            }
        }
        copy.setLoaded(true);
        return copy;
    }

    private AttributeData getAttributeData(AttributeReadable<?> source) {
        return (AttributeData)((Attribute)source).getOrcsData();
    }

    private Collection<AttributeTypeId> getAllowedTypes(Artifact destination, Collection<? extends AttributeTypeId> types) throws OseeCoreException {
        HashSet<AttributeTypeId> toReturn = new HashSet<AttributeTypeId>();
        for (AttributeTypeId attributeTypeId : types) {
            if (!attributeTypeId.notEqual((Id)CoreAttributeTypes.RelationOrder) || !destination.isAttributeTypeValid(attributeTypeId)) continue;
            toReturn.add(attributeTypeId);
        }
        return toReturn;
    }
}

