/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.core.ds.KeyValueDataAccessor;

public class SystemPreferencesImpl
implements SystemPreferences {
    private static Map<String, Pair<Long, String>> cache;
    private KeyValueDataAccessor accessor;

    public void setDataAccessor(KeyValueDataAccessor accessor) {
        this.accessor = accessor;
    }

    public void start() {
        cache = new ConcurrentHashMap<String, Pair<Long, String>>();
    }

    public void stop() {
        cache = null;
    }

    public String getSystemUuid() throws OseeCoreException {
        return this.getValue("osee.db.guid");
    }

    public String getValue(String key) throws OseeCoreException {
        String toReturn = this.accessor.getValue(key);
        SystemPreferencesImpl.cacheValue(key, toReturn);
        return toReturn;
    }

    public String getCachedValue(String key) throws OseeCoreException {
        return this.getCachedValue(key, Integer.MAX_VALUE);
    }

    public String getCachedValue(String key, long maxStaleness) throws OseeCoreException {
        Pair<Long, String> pair = cache.get(key);
        String value = pair == null || (Long)pair.getFirst() + maxStaleness < System.currentTimeMillis() ? this.getValue(key) : (String)pair.getSecond();
        return value;
    }

    public boolean isEnabled(String key) throws OseeCoreException {
        return this.isBoolean(key);
    }

    public boolean isCacheEnabled(String key) throws OseeCoreException {
        String dbProperty = this.getCachedValue(key);
        if (Strings.isValid((String)dbProperty)) {
            return dbProperty.equals("true");
        }
        return false;
    }

    public void setEnabled(String key, boolean enabled) throws OseeCoreException {
        this.setBoolean(key, enabled);
    }

    public void setBoolean(String key, boolean value) throws OseeCoreException {
        this.putValue(key, String.valueOf(value));
    }

    public boolean isBoolean(String key) throws OseeCoreException {
        String dbProperty = this.getValue(key);
        if (Strings.isValid((String)dbProperty)) {
            return dbProperty.equals("true");
        }
        return false;
    }

    public boolean isBooleanUsingCache(String key) throws OseeCoreException {
        return this.isCacheEnabled(key);
    }

    public void putValue(String key, String value) throws OseeCoreException {
        this.accessor.putValue(key, value);
        SystemPreferencesImpl.cacheValue(key, value);
    }

    public Set<String> getKeys() throws OseeCoreException {
        return this.accessor.getKeys();
    }

    private static void cacheValue(String key, String value) {
        Long time = System.currentTimeMillis();
        cache.put(key, (Pair<Long, String>)new Pair((Object)time, (Object)value));
    }
}

