/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.internal.branch.BranchDataFactory;
import org.eclipse.osee.orcs.core.internal.branch.CommitBranchCallable;
import org.eclipse.osee.orcs.core.internal.branch.CompareBranchCallable;
import org.eclipse.osee.orcs.core.internal.branch.CreateBranchCallable;
import org.eclipse.osee.orcs.core.internal.branch.PurgeBranchCallable;
import org.eclipse.osee.orcs.data.ArchiveOperation;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class OrcsBranchImpl
implements OrcsBranch {
    private final Log logger;
    private final OrcsSession session;
    private final BranchDataStore branchStore;
    private final BranchDataFactory branchDataFactory;
    private final OrcsTypes orcsTypes;
    private final QueryFactory queryFactory;

    public OrcsBranchImpl(Log logger, OrcsSession session, BranchDataStore branchStore, QueryFactory queryFactory, LazyObject<ArtifactReadable> systemUser, OrcsTypes orcsTypes) {
        this.logger = logger;
        this.session = session;
        this.branchStore = branchStore;
        this.branchDataFactory = new BranchDataFactory(queryFactory);
        this.orcsTypes = orcsTypes;
        this.queryFactory = queryFactory;
    }

    public Callable<BranchReadable> createBranch(CreateBranchData branchData) {
        return new CreateBranchCallable(this.logger, this.session, this.branchStore, branchData, this.queryFactory);
    }

    public Callable<Void> archiveUnarchiveBranch(BranchId branch, ArchiveOperation archiveOp) {
        return this.branchStore.archiveUnArchiveBranch(this.session, branch, archiveOp);
    }

    public Callable<Void> deleteBranch(BranchId branch) {
        return this.branchStore.deleteBranch(this.session, branch);
    }

    public Callable<List<BranchId>> purgeBranch(BranchId branch, boolean recurse) {
        return new PurgeBranchCallable(this.logger, this.session, this.branchStore, branch, recurse, this.queryFactory);
    }

    public Callable<TransactionToken> commitBranch(ArtifactId committer, BranchId source, BranchId destination) {
        return new CommitBranchCallable(this.logger, this.session, this.branchStore, this.queryFactory, committer, source, destination);
    }

    public Callable<List<ChangeItem>> compareBranch(TransactionToken sourceTx, TransactionToken destinationTx) {
        return new CompareBranchCallable(this.logger, this.session, this.branchStore, sourceTx, destinationTx, this.queryFactory.applicabilityQuery());
    }

    public Callable<List<ChangeItem>> compareBranch(BranchId branch) throws OseeCoreException {
        TransactionId baseTransaction = ((BranchReadable)((BranchQuery)this.queryFactory.branchQuery().andId(branch)).getResults().getExactlyOne()).getBaseTransaction();
        TransactionToken fromTx = (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andTxId(baseTransaction)).getResults().getExactlyOne();
        TransactionToken toTx = (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andIsHead(branch)).getResults().getExactlyOne();
        return this.branchStore.compareBranch(this.session, fromTx, toTx, this.queryFactory.applicabilityQuery());
    }

    public Callable<Void> changeBranchState(BranchId branch, BranchState branchState) {
        return this.branchStore.changeBranchState(this.session, branch, branchState);
    }

    public Callable<Void> changeBranchType(BranchId branch, BranchType branchType) {
        return this.branchStore.changeBranchType(this.session, branch, branchType);
    }

    public Callable<Void> changeBranchName(BranchId branch, String branchName) {
        return this.branchStore.changeBranchName(this.session, branch, branchName);
    }

    public Callable<Void> associateBranchToArtifact(BranchId branch, ArtifactId associatedArtifact) {
        Conditions.checkNotNull((Object)associatedArtifact, (String)"associatedArtifact");
        return this.branchStore.changeBranchAssociatedArt(this.session, branch, associatedArtifact);
    }

    public Callable<Void> unassociateBranch(BranchId branch) {
        return this.branchStore.changeBranchAssociatedArt(this.session, branch, ArtifactId.SENTINEL);
    }

    public Callable<URI> exportBranch(List<? extends BranchId> branches, PropertyStore options, String exportName) {
        return this.branchStore.exportBranch(this.session, this.orcsTypes, branches, options, exportName);
    }

    public Callable<URI> importBranch(URI fileToImport, List<? extends BranchId> branches, PropertyStore options) {
        return this.branchStore.importBranch(this.session, this.orcsTypes, fileToImport, branches, options);
    }

    public Callable<URI> checkBranchExchangeIntegrity(URI fileToCheck) {
        return this.branchStore.checkBranchExchangeIntegrity(this.session, fileToCheck);
    }

    public Callable<BranchReadable> createTopLevelBranch(IOseeBranch branch, ArtifactId author) throws OseeCoreException {
        CreateBranchData branchData = this.branchDataFactory.createTopLevelBranchData(branch, author);
        return this.createBranch(branchData);
    }

    public Callable<BranchReadable> createBaselineBranch(IOseeBranch branch, ArtifactId author, IOseeBranch parent, ArtifactId associatedArtifact) throws OseeCoreException {
        CreateBranchData branchData = this.branchDataFactory.createBaselineBranchData(branch, author, parent, associatedArtifact);
        return this.createBranch(branchData);
    }

    public Callable<BranchReadable> createWorkingBranch(IOseeBranch branch, ArtifactId author, IOseeBranch parent, ArtifactId associatedArtifact) throws OseeCoreException {
        CreateBranchData branchData = this.branchDataFactory.createWorkingBranchData(branch, author, parent, associatedArtifact);
        return this.createBranch(branchData);
    }

    public Callable<BranchReadable> createCopyTxBranch(IOseeBranch branch, ArtifactId author, TransactionId fromTransaction, ArtifactId associatedArtifact) throws OseeCoreException {
        CreateBranchData branchData = this.branchDataFactory.createCopyTxBranchData(branch, author, fromTransaction, associatedArtifact);
        return this.createBranch(branchData);
    }

    public Callable<BranchReadable> createPortBranch(IOseeBranch branch, ArtifactId author, TransactionId fromTransaction, ArtifactId associatedArtifact) throws OseeCoreException {
        CreateBranchData branchData = this.branchDataFactory.createPortBranchData(branch, author, fromTransaction, associatedArtifact);
        return this.createBranch(branchData);
    }
}

