/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsMetaData;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.DataStoreAdmin;
import org.eclipse.osee.orcs.core.internal.admin.CreateDatastoreCallable;
import org.eclipse.osee.orcs.core.internal.admin.FetchDatastoreMetadataCallable;
import org.eclipse.osee.orcs.core.internal.admin.MigrateDatastoreAdminCallable;

public class OrcsAdminImpl
implements OrcsAdmin {
    private final Log logger;
    private final OrcsSession session;
    private final DataStoreAdmin dataStoreAdmin;

    public OrcsAdminImpl(Log logger, OrcsSession session, DataStoreAdmin dataStoreAdmin) {
        this.logger = logger;
        this.session = session;
        this.dataStoreAdmin = dataStoreAdmin;
    }

    public Callable<OrcsMetaData> createDatastore(Map<String, String> parameters) {
        return new CreateDatastoreCallable(this.logger, this.session, this.dataStoreAdmin, parameters);
    }

    public Callable<OrcsMetaData> migrateDatastore() {
        return new MigrateDatastoreAdminCallable(this.logger, this.session, this.dataStoreAdmin);
    }

    public Callable<OrcsMetaData> createFetchOrcsMetaData() {
        return new FetchDatastoreMetadataCallable(this.logger, this.session, this.dataStoreAdmin);
    }

    public boolean isDataStoreInitialized() {
        return this.dataStoreAdmin.isDataStoreInitialized();
    }
}

