/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds.criteria;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.search.ArtifactQueryBuilder;

public class CriteriaAttributeOther
extends Criteria {
    public static final List<QueryOption> VALID_OPTIONS = Arrays.asList(QueryOption.TOKEN_COUNT__MATCH, QueryOption.TOKEN_DELIMITER__EXACT, QueryOption.TOKEN_MATCH_ORDER__MATCH, QueryOption.CASE__IGNORE, QueryOption.CASE__MATCH);
    private final Collection<AttributeTypeId> attributeTypes;
    private final Collection<String> values;
    private final List<QueryOption> options;

    public CriteriaAttributeOther(Collection<AttributeTypeId> attributeTypes, Collection<String> values, QueryOption ... options) {
        this.attributeTypes = attributeTypes;
        this.values = values;
        this.options = Lists.newArrayList((Object[])options);
    }

    public Collection<AttributeTypeId> getAttributeTypes() {
        return this.attributeTypes;
    }

    public Collection<String> getValues() {
        return this.values;
    }

    public List<QueryOption> getOptions() {
        return this.options;
    }

    @Override
    public void checkValid(Options options) throws OseeCoreException {
        Conditions.checkNotNullOrEmptyOrContainNull(this.getAttributeTypes(), (String)"attributeType");
        Conditions.checkExpressionFailOnTrue((boolean)this.getAttributeTypes().equals(ArtifactQueryBuilder.ANY_ATTRIBUTE_TYPE), (String)"Any attribute type is not allowed", (Object[])new Object[0]);
        List<QueryOption> unsupportedOptions = this.getUnsupportedOptions();
        if (unsupportedOptions.size() != 0) {
            throw new OseeArgumentException("Invalid QueryOptions present: [%s]", new Object[]{Collections.toString((String)",", unsupportedOptions)});
        }
    }

    private List<QueryOption> getUnsupportedOptions() {
        ArrayList selectedOptions = Lists.newArrayList(this.options);
        selectedOptions.removeAll(VALID_OPTIONS);
        return selectedOptions;
    }

    @Override
    public String toString() {
        return "CriteriaAttributeOther [attributeTypes=" + Collections.toString((String)",", this.attributeTypes) + ", values=" + this.values + ", options=" + Collections.toString((String)",", this.options) + "]";
    }
}

