/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.CriteriaSet;
import org.eclipse.osee.orcs.core.ds.HasOptions;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.SelectData;
import org.eclipse.osee.orcs.core.ds.SelectSet;

public class QueryData
implements HasOptions,
Cloneable {
    private final List<CriteriaSet> criterias;
    private final SelectData selectData;
    private final Options options;

    public QueryData(Options options, List<CriteriaSet> criterias, SelectData selectData) {
        this.criterias = criterias;
        this.selectData = selectData;
        this.options = options;
    }

    public QueryData(CriteriaSet criteriaSet, Options options) {
        this(options, new ArrayList<CriteriaSet>(), new SelectData());
        this.criterias.add(criteriaSet);
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    public List<Criteria> getAllCriteria() {
        ArrayList<Criteria> allCriterias = new ArrayList<Criteria>();
        for (CriteriaSet set : this.criterias) {
            allCriterias.addAll(set.getCriterias());
        }
        return allCriterias;
    }

    public List<CriteriaSet> getCriteriaSets() {
        return Collections.unmodifiableList(this.criterias);
    }

    public CriteriaSet getLastCriteriaSet() {
        return !this.criterias.isEmpty() ? this.criterias.get(this.criterias.size() - 1) : null;
    }

    public CriteriaSet newCriteriaSet() {
        CriteriaSet criteriaSet = new CriteriaSet();
        this.criterias.add(criteriaSet);
        this.selectData.newSelectSet();
        return criteriaSet;
    }

    public SelectSet getSelectSet() {
        SelectSet data = this.selectData.getLast();
        if (data == null) {
            data = this.selectData.newSelectSet();
        }
        return data;
    }

    public List<SelectSet> getSelectSets() {
        return this.selectData.getAll();
    }

    public void addCriteria(Criteria ... criterias) {
        CriteriaSet criteriaSet = this.getLastCriteriaSet();
        Criteria[] criteriaArray = criterias;
        int n = criterias.length;
        int n2 = 0;
        while (n2 < n) {
            Criteria criteria = criteriaArray[n2];
            criteriaSet.add(criteria);
            ++n2;
        }
    }

    public boolean hasCriteriaType(Class<? extends Criteria> type) {
        boolean result = false;
        for (CriteriaSet criteriaSet : this.criterias) {
            if (!criteriaSet.hasCriteriaType(type)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void reset() {
        this.options.reset();
        CriteriaSet criteriaSet = null;
        if (!this.criterias.isEmpty()) {
            criteriaSet = this.criterias.get(0);
            criteriaSet.reset();
        }
        this.criterias.clear();
        if (criteriaSet != null) {
            this.criterias.add(criteriaSet);
        }
    }

    public QueryData clone() {
        ArrayList<CriteriaSet> newCriterias = new ArrayList<CriteriaSet>(this.criterias.size());
        for (CriteriaSet criteriaSet : this.criterias) {
            newCriterias.add(criteriaSet.clone());
        }
        SelectData newSelectData = this.selectData.clone();
        return new QueryData(this.options.clone(), newCriterias, newSelectData);
    }

    public String toString() {
        return "QueryData [criterias=" + this.criterias + ", selects=" + this.selectData + ", options=" + this.options + "]";
    }
}

