/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.server.ide.internal;

import java.util.Collection;
import javax.servlet.Servlet;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.OseeHttpServlet;
import org.osgi.service.http.HttpService;

public final class ServletUtil {
    private ServletUtil() {
    }

    private static String normalizeContext(String contextName) {
        return !contextName.startsWith("/") ? "/" + contextName : contextName;
    }

    public static void register(HttpService httpService, IApplicationServerManager manager, OseeHttpServlet servlet, String context) {
        try {
            String contextName = ServletUtil.normalizeContext(context);
            httpService.registerServlet(contextName, (Servlet)servlet, null, null);
            manager.register(contextName, servlet);
            System.out.println(String.format("Registered servlet '%s'", contextName));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void unregister(HttpService httpService, IApplicationServerManager manager, Collection<String> contexts) {
        for (String context : contexts) {
            String contextName = ServletUtil.normalizeContext(context);
            if (httpService != null) {
                httpService.unregister(contextName);
            }
            if (manager != null) {
                manager.unregister(contextName);
            }
            System.out.println(String.format("De-registering servlet '%s'", contextName));
        }
    }
}

