/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.server.ide.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.OseeServerContext;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.ISessionManager;
import org.eclipse.osee.framework.core.server.OseeHttpServlet;
import org.eclipse.osee.framework.server.ide.AdminServlet;
import org.eclipse.osee.framework.server.ide.SessionClientLoopbackServlet;
import org.eclipse.osee.framework.server.ide.internal.ServletUtil;
import org.eclipse.osee.logger.Log;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;

public class ServletRegistrationHandler {
    private HttpService httpService;
    private Log logger;
    private ISessionManager sessionManager;
    private IApplicationServerManager appServerManager;
    private IAuthenticationManager authenticationManager;
    private ActivityLog activityLog;
    private final Set<String> contexts = new HashSet<String>();

    public void setSessionManager(ISessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setAppServerManager(IApplicationServerManager appServerManager) {
        this.appServerManager = appServerManager;
    }

    public void setAuthenticationManager(IAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public synchronized void start(BundleContext context) {
        ServletUtil.unregister(this.httpService, this.appServerManager, this.contexts);
        this.registerServices(context);
    }

    public synchronized void stop() {
        ServletUtil.unregister(this.httpService, this.appServerManager, this.contexts);
        this.contexts.clear();
    }

    private void registerServices(BundleContext context) {
        this.contexts.clear();
        this.register((OseeHttpServlet)new SessionClientLoopbackServlet(this.logger, this.sessionManager), OseeServerContext.CLIENT_LOOPBACK_CONTEXT);
        this.register((OseeHttpServlet)new AdminServlet(this.logger, context), "osee/console");
    }

    private void register(OseeHttpServlet servlet, String contexts) {
        this.contexts.add(contexts);
        ServletUtil.register(this.httpService, this.appServerManager, servlet, contexts);
    }

    public void setActivityLog(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }
}

