/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.server.ide.internal;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IdeClientSession;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.HttpProcessor;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.server.ide.api.client.ClientEndpoint;
import org.eclipse.osee.framework.server.ide.api.client.model.ClientDetails;
import org.eclipse.osee.framework.server.ide.api.client.model.ClientInfo;
import org.eclipse.osee.framework.server.ide.api.client.model.Sessions;
import org.eclipse.osee.framework.server.ide.api.model.IdeVersion;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class ClientEndpointImpl
implements ClientEndpoint {
    @Context
    private UriInfo uriInfo;
    private final JdbcService jdbcService;
    private final OrcsApi orcsApi;
    private static final String NEWEST_SESSIONS_BY_USER = "select client_address, user_id, created_on, client_port, client_version, session_id from osee_session where user_id = ? order by created_on desc";

    public ClientEndpointImpl(JdbcService jdbcService, OrcsApi orcsApi) {
        this.jdbcService = jdbcService;
        this.orcsApi = orcsApi;
    }

    @GET
    @Path(value="client")
    @Produces(value={"application/json"})
    public Response getAll() {
        Sessions activeSessions = new Sessions();
        activeSessions.get().addAll(this.getActiveSessions().keySet());
        return Response.ok((Object)activeSessions).build();
    }

    @GET
    @Path(value="client/details")
    @Produces(value={"application/json"})
    public Response getAllDetails() {
        ClientDetails details = new ClientDetails();
        Map<IdeClientSession, ClientInfo> activeSessions = this.getActiveSessions();
        for (Map.Entry<IdeClientSession, ClientInfo> entry : activeSessions.entrySet()) {
            IdeClientSession session = entry.getKey();
            details.getSessions().add(session);
            ClientInfo info = entry.getValue();
            this.increment(details.releaseCount, info.getVersion());
            this.addUserId(details.releaseToUserId, session.getClientVersion(), session.getUserId());
            if (!info.getInstallation().contains("osee-installs")) continue;
            details.networkReleaseUserIds.add(session.getUserId());
        }
        return Response.ok((Object)details).build();
    }

    @GET
    @Path(value="client/{idOrName}")
    @Produces(value={"application/json"})
    public Response getClientsForUser(@PathParam(value="idOrName") String idOrName) {
        System.out.println(String.format("getClientsForUser [%s]", idOrName));
        Sessions sessions = new Sessions();
        HashMap portToAlive = new HashMap();
        List<String> resolvedUserIds = this.getUserIds(idOrName);
        if (resolvedUserIds.isEmpty()) {
            throw new OseeArgumentException("User with id or name of [%s] not found", new Object[]{idOrName});
        }
        Consumer<JdbcStatement> consumer = stmt -> {
            IdeClientSession session = ClientEndpointImpl.createSession(stmt, this.uriInfo);
            String key = String.valueOf(session.getClientAddress()) + session.getClientPort();
            Boolean alive = (Boolean)portToAlive.get(key);
            if (alive == null) {
                alive = this.alive(session);
                portToAlive.put(key, alive);
                if (alive.booleanValue()) {
                    sessions.add(session);
                }
            }
        };
        for (String userId : resolvedUserIds) {
            this.jdbcService.getClient().runQueryWithLimit(consumer, 10, NEWEST_SESSIONS_BY_USER, new Object[]{userId});
        }
        return Response.ok((Object)sessions).build();
    }

    @GET
    @Path(value="client/{userId}/session/{sessionId}")
    @Produces(value={"text/plain"})
    public Response getClientInfo(@PathParam(value="userId") String userId, @PathParam(value="sessionId") String sessionId) {
        if (!GUID.isValid((String)sessionId)) {
            return Response.ok((Object)String.format("Session [%s] is invalid", sessionId)).build();
        }
        IdeClientSession session = this.getClientSession(sessionId);
        String infoStr = this.getInfoStr(session, true);
        return Response.ok((Object)infoStr).build();
    }

    @GET
    @Path(value="versions")
    @Produces(value={"application/json"})
    public IdeVersion getSupportedVersions() {
        IdeVersion versions = new IdeVersion();
        versions.addVersion(OseeCodeVersion.getVersion());
        return versions;
    }

    private List<String> getUserIds(String userIdOrName) {
        LinkedList<String> results = new LinkedList<String>();
        if (Strings.isNumeric((String)userIdOrName)) {
            results.add(userIdOrName);
        } else {
            for (ArtifactReadable userArt : ((QueryBuilder)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.User})).and((AttributeTypeId)CoreAttributeTypes.Name, userIdOrName, QueryOption.CONTAINS_MATCH_OPTIONS)).getResults()) {
                results.add((String)userArt.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.UserId, null));
            }
        }
        return results;
    }

    private static IdeClientSession createSession(JdbcStatement stmt, UriInfo uriInfo) {
        IdeClientSession session = new IdeClientSession(stmt.getString("CLIENT_ADDRESS"), stmt.getString("CLIENT_PORT"), stmt.getString("USER_ID"), stmt.getString("CLIENT_VERSION"), stmt.getString("SESSION_ID"), DateUtil.get((Date)stmt.getDate("CREATED_ON"), (String)"MM/dd/yyyy hh:mm a"));
        URI location = UriBuilder.fromPath((String)uriInfo.getBaseUri().toASCIIString()).path("client").path(stmt.getString("USER_ID")).path("session").path(stmt.getString("SESSION_ID")).build(new Object[0]);
        session.setSessionLog(location.toString());
        return session;
    }

    private Map<IdeClientSession, ClientInfo> getActiveSessions() {
        HashMap<IdeClientSession, ClientInfo> sessionToInfo = new HashMap<IdeClientSession, ClientInfo>(200);
        HashSet pinged = new HashSet(200);
        Consumer<JdbcStatement> consumer = stmt -> {
            IdeClientSession session = ClientEndpointImpl.createSession(stmt, this.uriInfo);
            String key = String.valueOf(session.getClientAddress()) + session.getClientPort();
            if (!pinged.contains(key)) {
                ClientInfo info = this.getClientInfo(session.getSessionId());
                if (info != null) {
                    sessionToInfo.put(session, info);
                }
                pinged.add(key);
            }
        };
        this.jdbcService.getClient().runQuery(consumer, "select * from osee_session where created_on > CURRENT_DATE - INTERVAL '7' DAY order by created_on desc", new Object[0]);
        return sessionToInfo;
    }

    private void addUserId(Map<String, Collection<String>> releaseToUserId, String release, String userId) {
        Collection<String> userIds = releaseToUserId.get(release);
        if (userIds == null) {
            userIds = new HashSet<String>(100);
        }
        userIds.add(userId);
        releaseToUserId.put(release, userIds);
    }

    private void increment(Map<String, Integer> releaseCount, String version) {
        Integer count = releaseCount.get(version);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        releaseCount.put(version, count);
    }

    private ClientInfo getClientInfo(String sessionId) {
        IdeClientSession session = this.getClientSession(sessionId);
        String infoStr = this.getInfoStr(session, false);
        if (Strings.isValid((String)infoStr)) {
            return new ClientInfo(infoStr);
        }
        return null;
    }

    private IdeClientSession getClientSession(String sessionId) {
        return (IdeClientSession)this.jdbcService.getClient().fetch(null, stmt -> ClientEndpointImpl.createSession(stmt, this.uriInfo), "select * from osee_session where session_id = ?", new Object[]{sessionId});
    }

    private boolean alive(IdeClientSession session) throws OseeCoreException {
        boolean alive = this.isHostAlive(session);
        if (!alive) {
            return false;
        }
        alive = false;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            URL url = new URL(String.format("http://%s:%s/osee/request?cmd=pingId", session.getClientAddress(), session.getClientPort()));
            HttpProcessor.AcquireResult result = HttpProcessor.acquire((URL)url, (OutputStream)outputStream, (int)1000);
            if (result.wasSuccessful()) {
                alive = true;
            }
        }
        catch (Exception exception) {}
        return alive;
    }

    private boolean isHostAlive(IdeClientSession session) {
        boolean reachable = false;
        try {
            String osName = System.getProperty("os.name");
            String option = osName.toLowerCase().contains("windows") ? "-n" : "-c";
            Process p1 = Runtime.getRuntime().exec(String.format("ping %s 1 %s", option, session.getClientAddress()));
            int returnVal = p1.waitFor();
            reachable = returnVal == 0;
        }
        catch (Exception exception) {}
        return reachable;
    }

    private String getInfoStr(IdeClientSession session, boolean withLog) throws OseeCoreException {
        block4: {
            try {
                boolean alive = this.isHostAlive(session);
                if (alive) break block4;
                return "Host Not Alive";
            }
            catch (Exception exception) {}
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        URL url = new URL(String.format("http://%s:%s/osee/request?cmd=" + (withLog ? "log" : "info"), session.getClientAddress(), session.getClientPort()));
        HttpProcessor.AcquireResult result = HttpProcessor.acquire((URL)url, (OutputStream)outputStream, (int)1000);
        if (result.wasSuccessful()) {
            return outputStream.toString(result.getEncoding());
        }
        return "";
    }
}

