/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.server.ide.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;

public class ServletResourceBridge
implements IResource {
    private static final String IS_COMPRESSED = "is.compressed";
    private final HttpServletRequest request;
    private final IResourceLocator locator;

    public ServletResourceBridge(HttpServletRequest request, IResourceLocator locator) {
        this.request = request;
        this.locator = locator;
    }

    public InputStream getContent() throws OseeCoreException {
        try {
            return this.request.getInputStream();
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public URI getLocation() {
        return this.locator.getLocation();
    }

    public String getName() {
        String path = this.locator.getLocation().toASCIIString();
        int index = path.lastIndexOf("/");
        if (index != -1 && index + 1 < path.length()) {
            path = path.substring(index + 1, path.length());
        }
        return path;
    }

    public boolean isCompressed() {
        return Boolean.valueOf(this.request.getParameter(IS_COMPRESSED));
    }
}

