/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.template.engine;

import java.io.IOException;
import org.eclipse.osee.framework.jdk.core.type.Identity;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.template.engine.AppendableRule;

public abstract class OptionsRule<T extends Identity<?> & Named>
extends AppendableRule<T> {
    private final String listId;

    protected String getListId() {
        return this.listId;
    }

    public OptionsRule(String ruleName) {
        this(ruleName, null);
    }

    public OptionsRule(String ruleName, String listId) {
        super(ruleName);
        this.listId = listId;
    }

    @Override
    public void applyTo(Appendable appendable) throws IOException {
        if (this.listId == null) {
            this.appendOptions(appendable);
        } else {
            appendable.append("\n<datalist id=\"");
            appendable.append(this.listId);
            appendable.append("\">\n");
            this.appendOptions(appendable);
            appendable.append("</datalist>\n");
        }
    }

    public abstract Iterable<T> getOptions();

    @Override
    public void applyTo(Appendable appendable, T option) throws IOException {
        appendable.append("<option value=\"");
        appendable.append(((Named)option).getName());
        appendable.append("\" guid=\"");
        appendable.append(String.valueOf(option.getGuid()));
        appendable.append("\">\n");
    }

    private void appendOptions(Appendable appendable) throws IOException {
        for (Identity option : this.getOptions()) {
            this.applyTo(appendable, (T)option);
        }
    }
}

