/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.ErrorResponse;

public class OseeWebApplicationException
extends WebApplicationException {
    private static final long serialVersionUID = -1566145923396351675L;
    private static final String EXCEPTION_NOT_AVAILABLE = "N/A";
    private static final String DEFAULT_ERROR_MESSAGE = "Exception message unavaliable - both exception and message were null";
    private final Response.StatusType errorStatus;
    private final String errorMessage;
    private final ErrorResponse errorResponse;

    public OseeWebApplicationException(Response.Status status) {
        this(null, status);
    }

    public OseeWebApplicationException(Response.Status status, String message, Object ... args) {
        this(null, (Response.StatusType)status, message, args);
    }

    public OseeWebApplicationException(Throwable cause, Response.Status status) {
        this(cause, (Response.StatusType)status, null, new Object[0]);
    }

    public OseeWebApplicationException(Throwable cause, Response.StatusType status, String message, Object ... args) {
        super(cause, status.getStatusCode());
        this.errorStatus = status;
        this.errorMessage = message != null ? OseeWebApplicationException.formatMessage(message, args) : null;
        this.errorResponse = OseeWebApplicationException.newErrorResponse(this.getCause(), this.errorStatus, this.errorMessage);
    }

    public Response getResponse() {
        return Response.status((Response.StatusType)this.getErrorStatus()).entity((Object)this.getErrorResponse()).header("osee-jaxrs-error-response", (Object)Boolean.TRUE).build();
    }

    public Response.StatusType getErrorStatus() {
        return this.errorStatus;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ErrorResponse getErrorResponse() {
        return this.errorResponse;
    }

    private static ErrorResponse newErrorResponse(Throwable throwable, Response.StatusType errorStatus, String errorMsg) {
        ErrorResponse response = new ErrorResponse();
        String exceptionMsg = throwable != null ? Lib.exceptionToString((Throwable)throwable) : EXCEPTION_NOT_AVAILABLE;
        response.setException(exceptionMsg);
        String errorMsgToSet = errorMsg;
        if (errorMsgToSet == null) {
            errorMsgToSet = throwable != null ? throwable.getLocalizedMessage() : DEFAULT_ERROR_MESSAGE;
        }
        response.setErrorMessage(errorMsgToSet);
        Response.StatusType status = errorStatus != null ? errorStatus : Response.Status.INTERNAL_SERVER_ERROR;
        response.setErrorCode(status.getStatusCode());
        response.setErrorReason(status.getReasonPhrase());
        response.setErrorType(status.getFamily().toString());
        return response;
    }

    private static String formatMessage(String message, Object ... args) {
        String toReturn = message;
        if (args != null && args.length > 0) {
            try {
                toReturn = String.format(message, args);
            }
            catch (RuntimeException ex) {
                toReturn = String.format("Exception message could not be formatted: [%s] with the following arguments [%s].  Cause [%s]", message, Collections.toString((String)",", (Object[])args), ex.toString());
            }
        }
        return toReturn;
    }
}

