/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.jaxrs.JsonMappingExceptionMapper;
import org.codehaus.jackson.jaxrs.JsonParseExceptionMapper;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

@Provider
public class JacksonFeature
implements Feature {
    private static final String JSON_FEATURE = JacksonFeature.class.getName();
    public static final String JAXRS_CONFIG_PREFIX = "jaxrs";
    public static final String JAXRS_CONFIG_PREFIX_AND_DOT = "jaxrs.";
    public static final String JSON_FEATURE_KEY = "jaxrs.jsonFeature";

    public boolean configure(FeatureContext context) {
        String propertyKey;
        boolean configured = false;
        Configuration config = context.getConfiguration();
        String jsonFeature = this.getJsonFeature(config, propertyKey = JacksonFeature.getPropertyNameForRuntime(JSON_FEATURE_KEY, config.getRuntimeType()), JSON_FEATURE);
        if (JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            context.property(propertyKey, (Object)JSON_FEATURE);
            if (!config.isRegistered(JacksonJaxbJsonProvider.class)) {
                for (Object object : JacksonFeature.getProviders()) {
                    context.register(object);
                }
            }
            configured = true;
        }
        return configured;
    }

    private String getJsonFeature(Configuration config, String propertyKey, String defaultValue) {
        Object value;
        String toReturn = defaultValue;
        Map props = config.getProperties();
        Object v0 = value = props != null ? props.get(propertyKey) : null;
        if (value != null) {
            toReturn = String.valueOf(value);
        }
        return toReturn;
    }

    public static String getPropertyNameForRuntime(String key, RuntimeType runtimeType) {
        if (runtimeType != null && key.startsWith(JAXRS_CONFIG_PREFIX)) {
            RuntimeType[] types;
            RuntimeType[] runtimeTypeArray = types = RuntimeType.values();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                RuntimeType type = runtimeTypeArray[n2];
                if (key.startsWith(JAXRS_CONFIG_PREFIX_AND_DOT + type.name().toLowerCase())) {
                    return key;
                }
                ++n2;
            }
            return key.replace(JAXRS_CONFIG_PREFIX, JAXRS_CONFIG_PREFIX_AND_DOT + runtimeType.name().toLowerCase());
        }
        return key;
    }

    public static List<? extends Object> getProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(JacksonFeature.newJacksonJsonProvider());
        providers.add(JsonParseExceptionMapper.class);
        providers.add(JsonMappingExceptionMapper.class);
        return providers;
    }

    private static JacksonJsonProvider newJacksonJsonProvider() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, true);
        objectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        objectMapper.configure(SerializationConfig.Feature.WRAP_EXCEPTIONS, true);
        objectMapper.configure(SerializationConfig.Feature.WRITE_EMPTY_JSON_ARRAYS, true);
        objectMapper.configure(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        objectMapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        objectMapper.configure(SerializationConfig.Feature.AUTO_DETECT_GETTERS, true);
        objectMapper.configure(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS, true);
        objectMapper.configure(SerializationConfig.Feature.USE_ANNOTATIONS, true);
        objectMapper.configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        objectMapper.configure(SerializationConfig.Feature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS, true);
        objectMapper.configure(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        objectMapper.configure(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        objectMapper.configure(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, true);
        objectMapper.configure(DeserializationConfig.Feature.AUTO_DETECT_CREATORS, true);
        objectMapper.configure(DeserializationConfig.Feature.USE_ANNOTATIONS, true);
        objectMapper.configure(DeserializationConfig.Feature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
        objectMapper.configure(DeserializationConfig.Feature.UNWRAP_ROOT_VALUE, false);
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return new JacksonJaxbJsonProvider(objectMapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
    }
}

