/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap.internal;

import java.util.Map;
import org.eclipse.osee.authentication.admin.AuthenticatedUser;
import org.eclipse.osee.authentication.admin.AuthenticationProvider;
import org.eclipse.osee.authentication.admin.AuthenticationRequest;
import org.eclipse.osee.authentication.ldap.LdapConfiguration;
import org.eclipse.osee.authentication.ldap.LdapConfigurationBuilder;
import org.eclipse.osee.authentication.ldap.internal.LdapAuthenticationManager;
import org.eclipse.osee.authentication.ldap.internal.LdapClient;
import org.eclipse.osee.authentication.ldap.internal.LdapConnectionFactoryImpl;
import org.eclipse.osee.logger.Log;

public final class LdapAuthenticationProvider
implements AuthenticationProvider {
    private static final String LDAP_SCHEME = "LDAP";
    private Log logger;
    private LdapAuthenticationManager authenticator;
    private LdapConfiguration config;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start(Map<String, Object> properties) {
        this.logger.trace("Starting LdapAuthenticationProvider...", new Object[0]);
        LdapConnectionFactoryImpl factory = new LdapConnectionFactoryImpl(this.logger);
        LdapClient client = new LdapClient(factory);
        this.authenticator = new LdapAuthenticationManager(client);
        this.update(properties);
    }

    public void stop() {
        this.logger.trace("Stopping LdapAuthenticationProvider...", new Object[0]);
        this.config = null;
        this.authenticator = null;
    }

    public void update(Map<String, Object> properties) {
        this.logger.trace("Configuring LdapAuthenticationProvider...", new Object[0]);
        this.config = LdapConfigurationBuilder.newBuilder().properties(properties).build();
        if (this.authenticator != null) {
            this.authenticator.configure(this.config);
        }
    }

    public String getAuthenticationScheme() {
        return LDAP_SCHEME;
    }

    public AuthenticatedUser authenticate(AuthenticationRequest request) {
        return this.authenticator.authenticate(request);
    }
}

