/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap.internal;

import java.io.Closeable;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import org.eclipse.osee.authentication.admin.AuthenticatedUser;
import org.eclipse.osee.authentication.admin.AuthenticationAdmin;
import org.eclipse.osee.authentication.admin.AuthenticationRequest;
import org.eclipse.osee.authentication.ldap.LdapAuthenticationType;
import org.eclipse.osee.authentication.ldap.LdapConfiguration;
import org.eclipse.osee.authentication.ldap.LdapConstants;
import org.eclipse.osee.authentication.ldap.LdapCredentialsSource;
import org.eclipse.osee.authentication.ldap.LdapReferralHandlingType;
import org.eclipse.osee.authentication.ldap.internal.LdapAccount;
import org.eclipse.osee.authentication.ldap.internal.LdapClient;
import org.eclipse.osee.authentication.ldap.internal.LdapConnection;
import org.eclipse.osee.authentication.ldap.internal.LdapFilter;
import org.eclipse.osee.authentication.ldap.internal.LdapGroup;
import org.eclipse.osee.authentication.ldap.internal.util.LdapUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class LdapAuthenticationManager {
    private final LdapClient client;
    private boolean isUserNameToLowerCaseEnabled = false;
    private LdapCredentialsSource loginType = LdapConstants.DEFAULT_LDAP_CREDENTIALS_SOURCE;
    private LdapAuthenticationType systemAuthType = LdapConstants.DEFAULT_AUTHENTICATION_TYPE;
    private String systemUserName;
    private String systemPassword;
    private String groupNamespace;
    private LdapFilter ldapFilter;

    public LdapAuthenticationManager(LdapClient client) {
        this.client = client;
    }

    public void configure(LdapConfiguration config) {
        String serverAddress = LdapUtil.getValue(config.getServerAddress(), "");
        long readTimeoutInMillis = LdapUtil.getValue(config.getReadTimeoutInMillis(), -1L);
        boolean isSslVerifyEnabled = LdapUtil.getValue(config.isSslVerifyEnabled(), true);
        LdapReferralHandlingType referral = LdapUtil.getValue(config.getReferralHandlingType(), LdapConstants.DEFAULT_LDAP_REFERRAL_HANDLING);
        this.isUserNameToLowerCaseEnabled = LdapUtil.getValue(config.isUserNameToLowerCaseEnabled(), false);
        this.loginType = LdapUtil.getValue(config.getCredentialsSource(), LdapConstants.DEFAULT_LDAP_CREDENTIALS_SOURCE);
        this.systemAuthType = LdapUtil.getValue(config.getAuthenticationType(), LdapConstants.DEFAULT_AUTHENTICATION_TYPE);
        this.groupNamespace = LdapUtil.getValue(config.getGroupNamespace(), "ldap");
        this.systemUserName = LdapUtil.getValue(config.getUsername(), null);
        this.systemPassword = LdapUtil.getValue(config.getPassword(), null);
        this.client.setServerAddress(serverAddress);
        this.client.setReadTimeoutInMillis(readTimeoutInMillis);
        this.client.setSslVerifyEnabled(isSslVerifyEnabled);
        this.client.setReferralHandling(referral);
        this.ldapFilter = LdapUtil.newLdapFilter(config);
    }

    public AuthenticatedUser authenticate(AuthenticationRequest request) {
        String username = request.getUserName();
        String password = request.getPassword();
        if (this.isUserNameToLowerCaseEnabled) {
            username = username.toLowerCase(Locale.US);
        }
        AuthenticatedUser authenticatedUser = null;
        try {
            authenticatedUser = this.loginType.isSystemCredentials() ? this.authenticateConnectWithLdapSystemCredentials(username, password) : this.authenticateConnectWithUserCredentials(username, password);
        }
        catch (PrivilegedActionException ex) {
            throw new OseeCoreException((Throwable)ex, "Cannot connect to LDAP", new Object[0]);
        }
        catch (NamingException ex) {
            throw new OseeCoreException((Throwable)ex, "Cannot query LDAP for account", new Object[0]);
        }
        catch (LoginException ex) {
            throw new OseeCoreException((Throwable)ex, "Cannot authenticate via JAAS", new Object[0]);
        }
        return authenticatedUser;
    }

    private AuthenticatedUser authenticateConnectWithLdapSystemCredentials(String username, String password) throws LoginException, NamingException, PrivilegedActionException {
        AuthenticatedUser authenticatedUser;
        LdapConnection connection = null;
        try {
            connection = this.client.getConnection(this.systemAuthType, this.systemUserName, this.systemPassword);
            LdapAccount account = connection.findAccount(this.ldapFilter, username);
            boolean isAuthenticated = connection.authenticate(account.getDistinguishedName(), password);
            Set<String> roles = isAuthenticated ? this.getRoles(connection, username, account) : Collections.emptySet();
            authenticatedUser = this.createPrincipal(isAuthenticated, account, roles);
        }
        catch (Throwable throwable) {
            Lib.close(connection);
            throw throwable;
        }
        Lib.close((Closeable)connection);
        return authenticatedUser;
    }

    private AuthenticatedUser authenticateConnectWithUserCredentials(String username, String password) throws LoginException, NamingException, PrivilegedActionException {
        AuthenticatedUser authenticatedUser;
        LdapConnection connection = null;
        try {
            connection = this.client.getConnection(LdapAuthenticationType.SIMPLE, username, password);
            LdapAccount account = connection.findAccount(this.ldapFilter, username);
            Set<String> roles = this.getRoles(connection, username, account);
            authenticatedUser = this.createPrincipal(true, account, roles);
        }
        catch (Throwable throwable) {
            Lib.close(connection);
            throw throwable;
        }
        Lib.close((Closeable)connection);
        return authenticatedUser;
    }

    private Set<String> getRoles(LdapConnection connection, String username, LdapAccount account) {
        LinkedHashSet<String> roles = new LinkedHashSet<String>();
        try {
            Set<LdapGroup> groups = connection.findGroups(this.ldapFilter, username, account);
            if (Strings.isValid((String)this.groupNamespace)) {
                for (LdapGroup group : groups) {
                    roles.add(String.format("%s__%s", this.groupNamespace, group.getGroupName()));
                }
            } else {
                for (LdapGroup group : groups) {
                    roles.add(group.getGroupName());
                }
            }
        }
        catch (NamingException ex) {
            throw new OseeCoreException((Throwable)ex, "Error getting ldap groups", new Object[0]);
        }
        return roles;
    }

    private AuthenticatedUser createPrincipal(boolean isAuthenticated, LdapAccount account, Set<String> roles) throws NamingException {
        AuthenticatedUser authenticated;
        if (isAuthenticated) {
            String displayName = account.getDisplayName();
            String emailAddress = account.getEmailAddress();
            String userName = account.getUserName();
            authenticated = this.newAuthenticated(displayName, emailAddress, userName, roles);
        } else {
            authenticated = AuthenticationAdmin.ANONYMOUS_USER;
        }
        return authenticated;
    }

    private AuthenticatedUser newAuthenticated(final String displayName, final String emailAddress, final String userName, final Set<String> roles) {
        return new AuthenticatedUser(){

            public String getName() {
                return displayName;
            }

            public String getDisplayName() {
                return displayName;
            }

            public String getUserName() {
                return userName;
            }

            public String getEmailAddress() {
                return emailAddress;
            }

            public boolean isActive() {
                return true;
            }

            public Iterable<String> getRoles() {
                return roles;
            }

            public boolean isAuthenticated() {
                return true;
            }
        };
    }
}

