/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap;

import org.eclipse.osee.framework.jdk.core.util.Strings;

public enum LdapAuthenticationType {
    NONE("none"),
    SIMPLE("simple"),
    DIGEST_MD5("strong"),
    EXTERNAL("strong"),
    GSSAPI("strong");

    private String authStyle;

    private LdapAuthenticationType(String authStyle) {
        this.authStyle = authStyle;
    }

    public String getContextAuthenticationName() {
        return this.authStyle;
    }

    public static LdapAuthenticationType parse(String value) {
        LdapAuthenticationType toReturn = NONE;
        if (Strings.isValid((String)value)) {
            String toFind = value.toUpperCase().trim();
            LdapAuthenticationType[] ldapAuthenticationTypeArray = LdapAuthenticationType.values();
            int n = ldapAuthenticationTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LdapAuthenticationType type = ldapAuthenticationTypeArray[n2];
                if (type.name().equals(toFind)) {
                    toReturn = type;
                    break;
                }
                ++n2;
            }
        }
        return toReturn;
    }
}

