/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchViewData;
import org.eclipse.osee.framework.core.data.FeatureDefinitionData;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.type.Pair;

@Path(value="applic")
public interface ApplicabilityEndpoint {
    @GET
    @Produces(value={"application/json"})
    public List<ApplicabilityToken> getApplicabilityTokens();

    @GET
    @Path(value="feature/data")
    @Produces(value={"application/json"})
    public List<FeatureDefinitionData> getFeatureDefinitionData();

    @GET
    @Path(value="view/{viewId}")
    @Produces(value={"application/json"})
    public List<ApplicabilityToken> getViewApplicabilityTokens(@PathParam(value="viewId") ArtifactId var1);

    @PUT
    @Path(value="artifact/reference")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setApplicabilityReference(HashMap<ArtifactId, List<ApplicabilityId>> var1);

    @GET
    @Path(value="artifact/reference/{artId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ApplicabilityId> getApplicabilitiesReferenced(@PathParam(value="artId") ArtifactId var1);

    @GET
    @Path(value="artifact/reference/token/{artId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ApplicabilityToken> getApplicabilityReferenceTokens(@PathParam(value="artId") ArtifactId var1);

    @PUT
    @Path(value="{applicId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setApplicability(@PathParam(value="applicId") ApplicabilityId var1, List<? extends ArtifactId> var2);

    @POST
    public void createDemoApplicability();

    @GET
    @Path(value="artifact/{artId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ApplicabilityToken getApplicabilityToken(@PathParam(value="artId") ArtifactId var1);

    @PUT
    @Path(value="artifacts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokensForArts(Collection<? extends ArtifactId> var1);

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(Collection<? extends ArtifactId> var1);

    @GET
    @Path(value="tokenMap")
    @Produces(value={"application/json"})
    public Collection<ApplicabilityToken> getApplicabilityTokenMap();

    @GET
    @Path(value="views")
    @Produces(value={"application/json"})
    public List<BranchViewData> getViews();

    @PUT
    @Path(value="branchview/{branchView}")
    @Consumes(value={"application/json"})
    public void setView(@PathParam(value="branchView") ArtifactId var1);

    @PUT
    @Path(value="change")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<BranchId> getAffectedBranches(@QueryParam(value="injectionDateMs") Long var1, @QueryParam(value="removalDateMs") @DefaultValue(value="-1") Long var2, List<ApplicabilityId> var3);

    @PUT
    @Path(value="change")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<BranchId> getAffectedBranches(@QueryParam(value="injectiontx") TransactionId var1, @QueryParam(value="removaltx") @DefaultValue(value="-1") TransactionId var2, List<ApplicabilityId> var3);

    @POST
    @Path(value="view/{viewId}/applic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionToken createNewApplicabilityForView(@PathParam(value="viewId") ArtifactId var1, String var2);
}

