/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.client.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.osee.define.report.api.WordUpdateEndpoint;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.server.ide.api.client.ClientEndpoint;
import org.eclipse.osee.jaxrs.client.JaxRsClient;
import org.eclipse.osee.jaxrs.client.JaxRsClientConfig;
import org.eclipse.osee.jaxrs.client.JaxRsExceptions;
import org.eclipse.osee.jaxrs.client.JaxRsWebTarget;
import org.eclipse.osee.orcs.rest.client.OseeClient;
import org.eclipse.osee.orcs.rest.client.QueryBuilder;
import org.eclipse.osee.orcs.rest.client.internal.search.PredicateFactory;
import org.eclipse.osee.orcs.rest.client.internal.search.PredicateFactoryImpl;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryBuilderImpl;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryExecutor;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryOptions;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;
import org.eclipse.osee.orcs.rest.model.IndexerEndpoint;
import org.eclipse.osee.orcs.rest.model.OrcsWriterEndpoint;
import org.eclipse.osee.orcs.rest.model.ResourcesEndpoint;
import org.eclipse.osee.orcs.rest.model.TransactionEndpoint;
import org.eclipse.osee.orcs.rest.model.TypesEndpoint;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.RequestType;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchRequest;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResponse;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResult;

public class OseeClientImpl
implements OseeClient,
QueryExecutor {
    private PredicateFactory predicateFactory;
    private volatile JaxRsClient client;
    private volatile URI baseUri;
    private volatile URI defineUri;

    public void start(Map<String, Object> properties) {
        this.predicateFactory = new PredicateFactoryImpl();
        this.update(properties);
    }

    public void stop() {
        this.client = null;
        this.baseUri = null;
        this.predicateFactory = null;
        this.defineUri = null;
    }

    public void update(Map<String, Object> properties) {
        String address;
        this.client = JaxRsClient.newBuilder().properties(properties).build();
        String string = address = properties != null ? (String)properties.get("osee.application.server") : null;
        if (address == null) {
            address = System.getProperty("osee.application.server", "http://localhost:8089");
        }
        if (Strings.isValid((String)address)) {
            this.baseUri = UriBuilder.fromUri((String)address).path("orcs").build(new Object[0]);
            this.defineUri = UriBuilder.fromUri((String)address).path("define").build(new Object[0]);
        }
    }

    private JaxRsWebTarget newTarget(String path, Object ... values) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path(path).build(values);
        return this.client.target(uri);
    }

    @Override
    public QueryBuilder createQueryBuilder(BranchId branch) {
        QueryOptions options = new QueryOptions();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        return new QueryBuilderImpl(branch, predicates, options, this.predicateFactory, this);
    }

    @Override
    public int getCount(BranchId branch, List<Predicate> predicates, QueryOptions options) throws OseeCoreException {
        SearchResponse result = this.performSearch(RequestType.COUNT, branch, predicates, options);
        return result.getTotal();
    }

    @Override
    public SearchResult getResults(RequestType request, BranchId branch, List<Predicate> predicates, QueryOptions options) throws OseeCoreException {
        SearchResponse result = this.performSearch(request, branch, predicates, options);
        return result;
    }

    private SearchResponse performSearch(RequestType requestType, BranchId branch, List<Predicate> predicates, QueryOptions options) throws OseeCoreException {
        Conditions.checkNotNull((Object)requestType, (String)"RequestType");
        int fromTx = 0;
        if (options.isHistorical()) {
            fromTx = options.getFromTransaction().getId().intValue();
        }
        boolean includeDeleted = false;
        if (options.areDeletedIncluded()) {
            includeDeleted = true;
        }
        SearchRequest params = new SearchRequest(branch, predicates, requestType, fromTx, includeDeleted);
        JaxRsWebTarget resource = this.newTarget("branch/{branch-uuid}/artifact/search/v1", branch.getUuid());
        try {
            return (SearchResponse)resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)params), SearchResponse.class);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public void executeScript(String script, Properties properties, boolean debug, MediaType mediaType, Writer writer) {
        String props = null;
        try {
            if (properties != null && !properties.isEmpty()) {
                StringWriter strWriter = new StringWriter();
                properties.store(strWriter, "");
                props = strWriter.toString();
            }
            Form form = new Form();
            form.param("script", script);
            form.param("debug", Boolean.toString(debug));
            if (props != null && props.length() > 0) {
                form.param("parameters", props);
            }
            URI uri = UriBuilder.fromUri((URI)this.baseUri).path("script").build(new Object[0]);
            String result = (String)JaxRsClient.newClient().target(uri).request(new MediaType[]{mediaType}).post(Entity.form((Form)form), String.class);
            writer.write(result);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public BranchEndpoint getBranchEndpoint() {
        return (BranchEndpoint)this.client.targetProxy(this.baseUri, BranchEndpoint.class);
    }

    @Override
    public TransactionEndpoint getTransactionEndpoint() {
        return (TransactionEndpoint)this.client.targetProxy(this.baseUri, TransactionEndpoint.class);
    }

    @Override
    public TypesEndpoint getTypesEndpoint() {
        return (TypesEndpoint)this.client.targetProxy(this.baseUri, TypesEndpoint.class);
    }

    @Override
    public IndexerEndpoint getIndexerEndpoint() {
        return (IndexerEndpoint)this.client.targetProxy(this.baseUri, IndexerEndpoint.class);
    }

    @Override
    public ClientEndpoint getClientEndpoint() {
        return (ClientEndpoint)this.client.targetProxy(this.baseUri, ClientEndpoint.class);
    }

    @Override
    public ResourcesEndpoint getResourcesEndpoint() {
        JaxRsClient newClient = JaxRsClient.newBuilder((JaxRsClientConfig)this.client.getConfig()).followRedirects(false).build();
        return (ResourcesEndpoint)newClient.targetProxy(this.baseUri, ResourcesEndpoint.class);
    }

    @Override
    public DatastoreEndpoint getDatastoreEndpoint() {
        return (DatastoreEndpoint)this.client.targetProxy(this.baseUri, DatastoreEndpoint.class);
    }

    @Override
    public WordUpdateEndpoint getWordUpdateEndpoint() {
        return (WordUpdateEndpoint)this.client.targetProxy(this.defineUri, WordUpdateEndpoint.class);
    }

    @Override
    public OrcsWriterEndpoint getOrcsWriterEndpoint() {
        return (OrcsWriterEndpoint)this.client.targetProxy(this.baseUri, OrcsWriterEndpoint.class);
    }

    @Override
    public ApplicabilityEndpoint getApplicabilityEndpoint(BranchId branch) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("branch/{branch}").build(new Object[]{branch.getId()});
        return (ApplicabilityEndpoint)this.client.targetProxy(uri, ApplicabilityEndpoint.class);
    }

    @Override
    public boolean isLocalHost() {
        return this.baseUri.toString().contains("localhost");
    }

    @Override
    public String getBaseUri() {
        return this.baseUri.toString();
    }
}

