/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.util;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.workflow.util.AbstractDuplicateWorkflowOperation;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class DuplicateWorkflowAtStartStateOperation
extends AbstractDuplicateWorkflowOperation {
    public DuplicateWorkflowAtStartStateOperation(Collection<IAtsTeamWorkflow> teamWfs, String title, IAtsUser asUser, IAtsServices services) {
        super(teamWfs, title, asUser, services);
    }

    public XResultData run() throws OseeCoreException {
        XResultData results = this.validate();
        if (results.isErrors()) {
            return results;
        }
        this.oldToNewMap = new HashMap();
        IAtsChangeSet changes = this.services.getStoreService().createAtsChangeSet("Duplicate Workflow - At Start State", this.asUser);
        Date createdDate = new Date();
        IAtsUser createdBy = this.services.getUserService().getCurrentUser();
        for (IAtsTeamWorkflow teamWf : this.teamWfs) {
            LinkedList<IAtsUser> assignees = new LinkedList<IAtsUser>();
            assignees.addAll(teamWf.getStateMgr().getAssignees());
            IAtsTeamDefinition teamDef = teamWf.getTeamDefinition();
            assignees.addAll(teamDef.getLeads());
            IAtsUser user = this.services.getUserService().getCurrentUser();
            if (!assignees.contains(user)) {
                assignees.add(user);
            }
            IAtsTeamWorkflow newTeamWf = this.services.getActionFactory().createTeamWorkflow(teamWf.getParentAction(), teamDef, (Collection)teamWf.getActionableItems(), assignees, changes, createdDate, createdBy, null, new CreateTeamOption[]{CreateTeamOption.Duplicate_If_Exists});
            String title = this.getTitle((IAtsWorkItem)teamWf);
            changes.setSoleAttributeValue((IAtsWorkItem)newTeamWf, (AttributeTypeId)CoreAttributeTypes.Name, title);
            changes.add((Object)newTeamWf);
            this.oldToNewMap.put(teamWf, newTeamWf);
        }
        changes.execute();
        return results;
    }
}

