/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.IAttribute;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.core.util.AtsCoreFactory;
import org.eclipse.osee.ats.core.workflow.util.AbstractDuplicateWorkflowOperation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class DuplicateWorkflowAsIsOperation
extends AbstractDuplicateWorkflowOperation {
    private final boolean duplicateTasks;
    private List<AttributeTypeId> excludeTypes;
    private static String ATS_CONFIG_EXCLUDE_DUPLICATE_TYPE_IDS_KEY = "DuplicateWorkflowAsIsOperation_ExcludeAttrTypeIds";

    public DuplicateWorkflowAsIsOperation(Collection<IAtsTeamWorkflow> teamWfs, boolean duplicateTasks, String title, IAtsUser asUser, IAtsServices services) {
        super(teamWfs, title, asUser, services);
        this.duplicateTasks = duplicateTasks;
    }

    public XResultData run() throws OseeCoreException {
        XResultData results = this.validate();
        if (results.isErrors()) {
            return results;
        }
        this.oldToNewMap = new HashMap();
        IAtsChangeSet changes = this.services.getStoreService().createAtsChangeSet("Duplicate Workflow - As-Is", this.asUser);
        for (IAtsTeamWorkflow teamWf : this.teamWfs) {
            IAtsWorkItem newTeamWf = this.duplicateWorkItem(changes, (IAtsWorkItem)teamWf);
            changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((IAtsUser)this.asUser, (IAtsWorkItem)newTeamWf, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Originator, AtsNotifyType.Assigned, AtsNotifyType.SubscribedTeamOrAi}));
            if (this.duplicateTasks) {
                for (IAtsTask task : this.services.getTaskService().getTask((IAtsWorkItem)teamWf)) {
                    IAtsTask dupTaskArt = (IAtsTask)this.duplicateWorkItem(changes, (IAtsWorkItem)task);
                    dupTaskArt.getLog().addLog(LogType.Note, null, "Task duplicated from " + task.getAtsId(), this.services.getUserService().getCurrentUser().getUserId());
                    changes.relate((Object)newTeamWf.getStoreObject(), AtsRelationTypes.TeamWfToTask_Task, (Object)dupTaskArt);
                    changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((IAtsUser)this.asUser, (IAtsWorkItem)dupTaskArt, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.SubscribedTeamOrAi}));
                    changes.add((Object)dupTaskArt);
                }
            }
            this.oldToNewMap.put(teamWf, (IAtsTeamWorkflow)newTeamWf);
        }
        changes.execute();
        return results;
    }

    private IAtsWorkItem duplicateWorkItem(IAtsChangeSet changes, IAtsWorkItem workItem) {
        ArtifactId newWorkItemArt = changes.createArtifact(this.services.getStoreService().getArtifactType((ArtifactId)workItem.getStoreObject()), this.getTitle(workItem));
        if (workItem.isTeamWorkflow()) {
            changes.relate((Object)newWorkItemArt, AtsRelationTypes.ActionToWorkflow_Action, (Object)workItem.getParentAction());
        }
        IAtsLog atsLog = AtsCoreFactory.getLogFactory().getLogLoaded(workItem, this.services.getAttributeResolver());
        atsLog.addLog(LogType.Note, null, "Workflow duplicated from " + workItem.getAtsId(), this.asUser.getUserId());
        LinkedList<IAtsUser> assignees = new LinkedList<IAtsUser>();
        assignees.addAll(workItem.getStateMgr().getAssignees());
        if (workItem.isTeamWorkflow()) {
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
            assignees.addAll(((IAtsTeamWorkflow)workItem).getTeamDefinition().getLeads());
            if (!assignees.contains(this.asUser)) {
                assignees.add(this.asUser);
            }
            this.services.getActionFactory().addActionToConfiguredGoal(teamWf.getTeamDefinition(), teamWf, (Collection)teamWf.getActionableItems(), changes);
        }
        for (IAttribute attr : this.services.getAttributeResolver().getAttributes((ArtifactId)workItem.getStoreObject())) {
            if (this.getExcludeTypes().contains(attr.getAttrType())) continue;
            changes.addAttribute(newWorkItemArt, (AttributeTypeId)attr.getAttrType(), attr.getValue());
        }
        IAtsWorkItem newWorkItem = this.services.getWorkItemFactory().getWorkItem(newWorkItemArt);
        this.services.getActionFactory().setAtsId((IAtsObject)newWorkItem, workItem.getParentTeamWorkflow().getTeamDefinition(), changes);
        return newWorkItem;
    }

    private List<AttributeTypeId> getExcludeTypes() {
        if (this.excludeTypes == null) {
            this.excludeTypes = new LinkedList<AttributeTypeId>();
            this.excludeTypes.add((AttributeTypeId)AtsAttributeTypes.AtsId);
            this.excludeTypes.add((AttributeTypeId)CoreAttributeTypes.Name);
            String value = this.services.getConfigValue(ATS_CONFIG_EXCLUDE_DUPLICATE_TYPE_IDS_KEY);
            if (Strings.isValid((String)value)) {
                String[] stringArray = value.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String attrTypeId = stringArray[n2];
                    if (Strings.isNumeric((String)attrTypeId)) {
                        AttributeTypeId attributeType = AttributeTypeId.valueOf((String)attrTypeId);
                        if (attributeType != null) {
                            this.excludeTypes.add(attributeType);
                        } else {
                            OseeLog.log(DuplicateWorkflowAsIsOperation.class, (Level)Level.SEVERE, (String)String.format("Can't resolve Attribute Type for id %d in AtsConfig.%s", attrTypeId, ATS_CONFIG_EXCLUDE_DUPLICATE_TYPE_IDS_KEY));
                        }
                    } else {
                        OseeLog.log(DuplicateWorkflowAsIsOperation.class, (Level)Level.SEVERE, (String)String.format("Can't resolve non-numeric Attribute Type for id %s in AtsConfig.%s", attrTypeId, ATS_CONFIG_EXCLUDE_DUPLICATE_TYPE_IDS_KEY));
                    }
                    ++n2;
                }
            }
        }
        return this.excludeTypes;
    }
}

