/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.transition;

import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.core.workflow.transition.TransitionStatusDataResult;
import org.eclipse.osee.framework.core.util.Result;

public class TransitionStatusData {
    private Integer percent;
    private Integer defaultPercent;
    private Double additionalHours;
    private boolean applyHoursToEachItem = false;
    private boolean splitHoursBetweenItems = true;
    private boolean showPercent;
    private Collection<? extends IAtsWorkItem> workItems;

    public TransitionStatusData(Collection<? extends IAtsWorkItem> workItems, boolean showPercent) {
        this.workItems = workItems;
        this.showPercent = showPercent;
    }

    public Result isValid() {
        if (this.isPercentRequired()) {
            if (this.isPercentSet()) {
                if (this.percent < 0 || this.percent > 99) {
                    return TransitionStatusDataResult.INVALID__UNCOMPLETE_PERCENT;
                }
            } else {
                return TransitionStatusDataResult.INVALID__PERCENT_MUST_BE_ENTERED;
            }
        }
        if (!this.isHoursSet()) {
            return TransitionStatusDataResult.INVALID__HOURS_MUST_BE_SET;
        }
        if (this.workItems.size() > 1) {
            if (!this.splitHoursBetweenItems && !this.applyHoursToEachItem) {
                return TransitionStatusDataResult.INVALID__SELECT_EITHER_SPLIT_OR_APPLY;
            }
            if (this.splitHoursBetweenItems && this.applyHoursToEachItem) {
                return TransitionStatusDataResult.INVALID__SELECT_ONLY_ONE_SPLIT_OR_APPLY;
            }
        }
        return Result.TrueResult;
    }

    private boolean isPercentSet() {
        return this.percent != null;
    }

    private boolean isHoursSet() {
        return this.additionalHours != null;
    }

    public Integer getPercent() {
        return this.percent;
    }

    public void setPercent(Integer percent) {
        this.percent = percent;
    }

    public Double getAdditionalHours() {
        return this.additionalHours;
    }

    public void setAdditionalHours(Double additionalHours) {
        this.additionalHours = additionalHours;
    }

    public boolean isSplitHoursBetweenItems() {
        return this.splitHoursBetweenItems;
    }

    public void setSplitHoursBetweenItems(boolean splitHoursBetweenItems) {
        this.splitHoursBetweenItems = splitHoursBetweenItems;
    }

    public Collection<? extends IAtsWorkItem> getWorkItems() {
        return this.workItems;
    }

    public void setAwas(Collection<? extends IAtsWorkItem> workItems) {
        this.workItems = workItems;
    }

    public boolean isPercentRequired() {
        return this.showPercent;
    }

    public void setPercentRequired(boolean percentRequired) {
        this.showPercent = percentRequired;
    }

    public Integer getDefaultPercent() {
        return this.defaultPercent;
    }

    public void setDefaultPercent(Integer defaultPercent) {
        this.defaultPercent = defaultPercent;
    }

    public void setApplyHoursToEachItem(boolean applyHoursToEachItem) {
        this.applyHoursToEachItem = applyHoursToEachItem;
    }

    public boolean isApplyHoursToEachItem() {
        return this.applyHoursToEachItem;
    }
}

