/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.transition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsReviewService;
import org.eclipse.osee.ats.api.task.IAtsTaskService;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.ITransitionResult;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemService;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.api.workflow.transition.IAtsTransitionManager;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionListener;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.core.workflow.WorkflowManagerCore;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class TransitionManager
implements IAtsTransitionManager,
IExecuteListener {
    private final ITransitionHelper helper;
    private String completedCancellationReason = null;
    private Date transitionOnDate;
    private final IAtsUserService userService;
    private final IAtsReviewService reviewService;
    private final IAtsWorkItemService workItemService;
    private final IAtsTaskService taskService;
    private final IAtsWorkDefinitionService workDefService;
    private final IAttributeResolver attrResolver;
    private final Map<IAtsWorkItem, String> workItemFromStateMap;

    public TransitionManager(ITransitionHelper helper) {
        this.helper = helper;
        this.userService = helper.getServices().getUserService();
        this.reviewService = helper.getServices().getReviewService();
        this.workItemService = helper.getServices().getWorkItemService();
        this.workDefService = helper.getServices().getWorkDefService();
        this.attrResolver = helper.getServices().getAttributeResolver();
        this.taskService = helper.getServices().getTaskService();
        this.workItemFromStateMap = new HashMap<IAtsWorkItem, String>();
    }

    public TransitionResults handleAll() {
        TransitionResults results = new TransitionResults();
        this.handleWorkflowReload(results);
        if (results.isCancelled() || !results.isEmpty()) {
            return results;
        }
        this.handleTransitionValidation(results);
        if (results.isCancelled() || !results.isEmpty()) {
            return results;
        }
        this.handleTransitionUi(results);
        if (results.isCancelled() || !results.isEmpty()) {
            return results;
        }
        this.handleTransition(results);
        return results;
    }

    private void handleWorkflowReload(TransitionResults results) {
        if (this.helper.isReload()) {
            this.helper.handleWorkflowReload(results);
        }
    }

    public void handleTransitionValidation(TransitionResults results) {
        boolean overrideAssigneeCheck = this.helper.isOverrideAssigneeCheck();
        try {
            if (this.helper.getWorkItems().isEmpty()) {
                results.addResult((ITransitionResult)TransitionResult.NO_WORKFLOWS_PROVIDED_FOR_TRANSITION);
                return;
            }
            if (this.helper.getToStateName() == null) {
                results.addResult((ITransitionResult)TransitionResult.TO_STATE_CANT_BE_NULL);
                return;
            }
            if (!overrideAssigneeCheck && this.helper.isSystemUser()) {
                results.addResult((ITransitionResult)TransitionResult.CAN_NOT_TRANSITION_AS_SYSTEM_USER);
                return;
            }
        }
        catch (OseeCoreException ex) {
            results.addResult((ITransitionResult)new TransitionResult(String.format("Exception while validating transition [%s]", this.helper.getName()), (Exception)((Object)ex)));
        }
        for (IAtsWorkItem workItem : this.helper.getWorkItems()) {
            try {
                this.helper.getChangeSet().add((Object)workItem);
                IAtsStateDefinition fromStateDef = workItem.getStateDefinition();
                IAtsStateDefinition toStateDef = workItem.getWorkDefinition().getStateByName(this.helper.getToStateName());
                if (toStateDef == null) {
                    results.addResult(workItem, (ITransitionResult)new TransitionResult(String.format("Transition-To State [%s] does not exist for Work Definition [%s]", this.helper.getToStateName(), workItem.getWorkDefinition().getName())));
                    continue;
                }
                if (fromStateDef.equals((Object)toStateDef)) continue;
                if (!(this.helper.isOverrideTransitionValidityCheck() || fromStateDef.getToStates().contains(toStateDef) || fromStateDef.getStateType().isCompletedOrCancelledState())) {
                    String errStr = String.format("Work Definition [%s] is not configured to transition from \"[%s]\" to \"[%s]\"", fromStateDef.getWorkDefinition().getName(), fromStateDef.getName(), toStateDef.getName());
                    OseeLog.log(TransitionManager.class, (Level)Level.SEVERE, (String)errStr);
                    results.addResult(workItem, (ITransitionResult)new TransitionResult(errStr));
                    continue;
                }
                boolean stateIsEditable = WorkflowManagerCore.isEditable(workItem, workItem.getStateDefinition(), this.helper.isPrivilegedEditEnabled(), this.helper.getTransitionUser(), this.userService.isAtsAdmin(this.helper.getTransitionUser()));
                boolean currentlyUnAssignedOrCompletedOrCancelled = workItem.isCompletedOrCancelled() || workItem.getStateMgr().getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER);
                workItem.getStateMgr().validateNoBootstrapUser();
                if (workItem.isTask() && workItem.getParentTeamWorkflow().getStateMgr().getStateType().isCompletedOrCancelled()) {
                    results.addResult(workItem, (ITransitionResult)TransitionResult.TASK_CANT_TRANSITION_IF_PARENT_COMPLETED);
                    continue;
                }
                if (!(workItem.isTask() || stateIsEditable || currentlyUnAssignedOrCompletedOrCancelled || overrideAssigneeCheck)) {
                    results.addResult(workItem, (ITransitionResult)TransitionResult.MUST_BE_ASSIGNED);
                    continue;
                }
                this.isWorkingBranchTransitionable(results, workItem, toStateDef);
                if (results.isCancelled()) continue;
                if (!overrideAssigneeCheck && !toStateDef.getStateType().isCancelledState() && this.helper.isSystemUserAssingee(workItem)) {
                    results.addResult(workItem, (ITransitionResult)TransitionResult.CAN_NOT_TRANSITION_WITH_SYSTEM_USER_ASSIGNED);
                    continue;
                }
                this.isStateTransitionable(results, workItem, toStateDef);
                if (results.isCancelled()) continue;
                this.isTransitionValidForExtensions(results, workItem, fromStateDef, toStateDef);
                if (results.isCancelled() || !this.helper.isExecuteChanges()) continue;
                this.helper.getChangeSet().execute();
            }
            catch (OseeCoreException ex) {
                results.addResult(workItem, (ITransitionResult)new TransitionResult(String.format("Exception while validating transition [%s]", this.helper.getName()), (Exception)((Object)ex)));
            }
        }
    }

    public void isTransitionValidForExtensions(TransitionResults results, IAtsWorkItem workItem, IAtsStateDefinition fromStateDef, IAtsStateDefinition toStateDef) {
        for (ITransitionListener listener : this.helper.getTransitionListeners()) {
            try {
                listener.transitioning(results, workItem, (IStateToken)fromStateDef, (IStateToken)toStateDef, this.getToAssignees(workItem, toStateDef));
                if (results.isCancelled() || results.isEmpty()) continue;
            }
            catch (OseeCoreException ex) {
                results.addResult(workItem, (ITransitionResult)new TransitionResult(String.format("Exception [%s] while validating transition extensions 1 [%s]", ex.getMessage(), this.helper.getName()), (Exception)((Object)ex)));
            }
        }
        if (results.isEmpty()) {
            for (ITransitionListener listener : this.helper.getTransitionListeners()) {
                try {
                    listener.transitioning(results, workItem, (IStateToken)fromStateDef, (IStateToken)toStateDef, this.getToAssignees(workItem, toStateDef));
                    if (results.isCancelled() || results.isEmpty()) continue;
                }
                catch (OseeCoreException ex) {
                    results.addResult(workItem, (ITransitionResult)new TransitionResult(String.format("Exception [%s] while validating transition extensions 2 [%s]", ex.getMessage(), this.helper.getName()), (Exception)((Object)ex)));
                }
            }
        }
    }

    public void handleTransitionUi(TransitionResults results) {
        Result result = this.helper.getCompleteOrCancellationReason();
        if (result.isCancelled()) {
            results.setCancelled(true);
            return;
        }
        if (result.isTrue()) {
            this.completedCancellationReason = result.getText();
        }
        if ((result = this.helper.handleExtraHoursSpent(this.helper.getChangeSet())).isCancelled()) {
            results.setCancelled(true);
        } else if (result.isFalse()) {
            results.addResult((ITransitionResult)new TransitionResult(result.getText()));
        }
    }

    public void handleTransition(TransitionResults results) {
        try {
            this.helper.getChangeSet().addExecuteListener((IExecuteListener)this);
            for (IAtsWorkItem workItem : this.helper.getWorkItems()) {
                try {
                    IAtsDecisionReview review;
                    IAtsStateDefinition fromState = workItem.getStateDefinition();
                    IAtsStateDefinition toState = workItem.getWorkDefinition().getStateByName(this.helper.getToStateName());
                    if (fromState.equals((Object)toState)) continue;
                    Date transitionDate = this.getTransitionOnDate();
                    IAtsUser transitionUser = this.getTransitionAsUser();
                    if (fromState.getStateType().isCancelledState()) {
                        TransitionManager.logWorkflowUnCancelledEvent(workItem, toState, this.helper.getChangeSet(), this.attrResolver);
                    } else if (fromState.getStateType().isCompletedState()) {
                        TransitionManager.logWorkflowUnCompletedEvent(workItem, toState, this.helper.getChangeSet(), this.attrResolver);
                    }
                    if (toState.getStateType().isCancelledState()) {
                        TransitionManager.logWorkflowCancelledEvent(workItem, fromState, toState, this.completedCancellationReason, transitionDate, transitionUser, this.helper.getChangeSet(), this.attrResolver);
                    } else if (toState.getStateType().isCompletedState()) {
                        this.logWorkflowCompletedEvent(workItem, fromState, toState, this.completedCancellationReason, transitionDate, transitionUser, this.helper.getChangeSet());
                    } else {
                        this.logStateCompletedEvent(workItem, workItem.getStateMgr().getCurrentStateName(), this.completedCancellationReason, transitionDate, transitionUser);
                    }
                    TransitionManager.logStateStartedEvent(workItem, (IStateToken)toState, transitionDate, transitionUser);
                    List<? extends IAtsUser> updatedAssigees = this.getToAssignees(workItem, toState);
                    workItem.getStateMgr().transitionHelper(updatedAssigees, (IStateToken)fromState, (IStateToken)toState, this.completedCancellationReason);
                    if (this.reviewService.isValidationReviewRequired(workItem) && workItem.isTeamWorkflow() && (review = this.reviewService.createValidateReview((IAtsTeamWorkflow)workItem, false, transitionDate, transitionUser, this.helper.getChangeSet())) != null) {
                        this.helper.getChangeSet().add((Object)review);
                    }
                    for (ITransitionListener listener : this.helper.getTransitionListeners()) {
                        listener.transitioned(workItem, (IStateToken)fromState, (IStateToken)toState, updatedAssigees, this.helper.getChangeSet());
                    }
                    if (toState.getStateType().isCompletedOrCancelledState()) {
                        this.workItemService.clearImplementersCache(workItem);
                    }
                    this.helper.getChangeSet().add((Object)workItem);
                    this.workItemFromStateMap.put(workItem, fromState.getName());
                }
                catch (Exception ex) {
                    results.addResult(workItem, (ITransitionResult)new TransitionResult(String.format("Exception while transitioning [%s]", this.helper.getName()), ex));
                }
            }
            if (results.isEmpty() && this.helper.isExecuteChanges()) {
                this.helper.getChangeSet().execute();
            }
        }
        catch (Exception ex) {
            results.addResult((ITransitionResult)new TransitionResult(String.format("Exception while transitioning [%s]", this.helper.getName()), ex));
        }
    }

    private void isWorkingBranchTransitionable(TransitionResults results, IAtsWorkItem workItem, IAtsStateDefinition toStateDef) throws OseeCoreException {
        if (workItem.isTeamWorkflow() && this.helper.isWorkingBranchInWork((IAtsTeamWorkflow)workItem)) {
            if (toStateDef.getName().equals(TeamState.Cancelled.getName())) {
                results.addResult(workItem, (ITransitionResult)TransitionResult.DELETE_WORKING_BRANCH_BEFORE_CANCEL);
            }
            if (this.helper.isBranchInCommit((IAtsTeamWorkflow)workItem)) {
                results.addResult(workItem, (ITransitionResult)TransitionResult.WORKING_BRANCH_BEING_COMMITTED);
            }
            if (!toStateDef.hasRule(RuleDefinitionOption.AllowTransitionWithWorkingBranch.name())) {
                results.addResult(workItem, (ITransitionResult)TransitionResult.WORKING_BRANCH_EXISTS);
            }
        }
    }

    private void isStateTransitionable(TransitionResults results, IAtsWorkItem workItem, IAtsStateDefinition toStateDef) throws OseeCoreException {
        boolean isOverrideAttributeValidationState;
        boolean bl = isOverrideAttributeValidationState = this.helper.isOverrideTransitionValidityCheck() || workItem.getStateDefinition().getOverrideAttributeValidationStates().contains(toStateDef);
        if (toStateDef.getStateType().isCancelledState()) {
            TransitionManager.validateTaskCompletion(results, workItem, toStateDef, this.taskService);
            this.validateReviewsCancelled(results, workItem, toStateDef);
        } else if (!toStateDef.getStateType().isCancelledState() && !isOverrideAttributeValidationState) {
            Collection widgetResults = this.workItemService.validateWidgetTransition(workItem, toStateDef);
            for (WidgetResult widgetResult : widgetResults) {
                if (widgetResult.isValid()) continue;
                results.addResult(workItem, (ITransitionResult)widgetResult);
            }
            TransitionManager.validateTaskCompletion(results, workItem, toStateDef, this.taskService);
            boolean teamDefRequiresTargetedVersion = this.workDefService.teamDefHasRule(workItem, RuleDefinitionOption.RequireTargetedVersion);
            boolean pageRequiresTargetedVersion = workItem.getStateDefinition().hasRule(RuleDefinitionOption.RequireTargetedVersion.name());
            if (workItem.isTeamWorkflow() && (teamDefRequiresTargetedVersion || pageRequiresTargetedVersion) && !this.helper.getServices().getVersionService().hasTargetedVersion(workItem) && !toStateDef.getStateType().isCancelledState()) {
                results.addResult(workItem, (ITransitionResult)TransitionResult.MUST_BE_TARGETED_FOR_VERSION);
            }
            if (workItem.isTeamWorkflow()) {
                for (IAtsAbstractReview review : this.reviewService.getReviewsFromCurrentState((IAtsTeamWorkflow)workItem)) {
                    if (this.reviewService.getReviewBlockType(review) != ReviewBlockType.Transition || review.getStateMgr().getStateType().isCompletedOrCancelled()) continue;
                    results.addResult(workItem, (ITransitionResult)TransitionResult.COMPLETE_BLOCKING_REVIEWS);
                }
            }
        }
    }

    private void validateReviewsCancelled(TransitionResults results, IAtsWorkItem workItem, IAtsStateDefinition toStateDef) throws OseeCoreException {
        if (workItem.isTeamWorkflow() && toStateDef.getStateType().isCancelledState()) {
            for (IAtsAbstractReview review : this.reviewService.getReviewsFromCurrentState((IAtsTeamWorkflow)workItem)) {
                ReviewBlockType reviewBlockType = this.reviewService.getReviewBlockType(review);
                boolean completedOrCancelled = review.getStateMgr().getStateType().isCompletedOrCancelled();
                if (reviewBlockType != ReviewBlockType.Transition || completedOrCancelled) continue;
                results.addResult(workItem, (ITransitionResult)TransitionResult.CANCEL_REVIEWS_BEFORE_CANCEL);
                break;
            }
        }
    }

    public static void validateTaskCompletion(TransitionResults results, IAtsWorkItem workItem, IAtsStateDefinition toStateDef, IAtsTaskService taskService) throws OseeCoreException {
        if (!workItem.isTeamWorkflow()) {
            return;
        }
        boolean checkTasksCompletedForState = true;
        if (workItem.getStateDefinition().hasRule(RuleDefinitionOption.AllowTransitionWithoutTaskCompletion.name()) && toStateDef.getStateType().isWorkingState()) {
            checkTasksCompletedForState = false;
        }
        if (checkTasksCompletedForState && workItem.getStateMgr().getStateType().isInWork()) {
            HashSet tasksToCheck = new HashSet();
            if (toStateDef.getStateType().isCompletedOrCancelledState()) {
                tasksToCheck.addAll(taskService.getTask(workItem));
            } else {
                tasksToCheck.addAll(taskService.getTasks(workItem, (IStateToken)workItem.getStateDefinition()));
            }
            for (IAtsTask task : tasksToCheck) {
                if (!task.getStateMgr().getStateType().isInWork()) continue;
                results.addResult(workItem, (ITransitionResult)TransitionResult.TASKS_NOT_COMPLETED);
                break;
            }
        }
    }

    public static void logWorkflowCancelledEvent(IAtsWorkItem workItem, IAtsStateDefinition fromState, IAtsStateDefinition toState, String reason, Date cancelDate, IAtsUser cancelBy, IAtsChangeSet changes, IAttributeResolver attrResolver) throws OseeCoreException {
        workItem.getLog().addLog(LogType.StateCancelled, fromState.getName(), reason, cancelDate, cancelBy.getUserId());
        if (attrResolver.isAttributeTypeValid(workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy)) {
            attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CancelledBy, (Object)cancelBy.getUserId(), changes);
            attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CancelledDate, (Object)cancelDate, changes);
            if (Strings.isValid((String)reason)) {
                attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CancelledReason, (Object)reason, changes);
            }
            attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CancelledFromState, (Object)fromState.getName(), changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    public static void logWorkflowUnCancelledEvent(IAtsWorkItem workItem, IAtsStateDefinition toState, IAtsChangeSet changes, IAttributeResolver attrResolver) throws OseeCoreException {
        if (attrResolver.isAttributeTypeValid(workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy)) {
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeId)AtsAttributeTypes.CancelledBy, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeId)AtsAttributeTypes.CancelledDate, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeId)AtsAttributeTypes.CancelledReason, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeId)AtsAttributeTypes.CancelledFromState, changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    private void logWorkflowCompletedEvent(IAtsWorkItem workItem, IAtsStateDefinition fromState, IAtsStateDefinition toState, String reason, Date cancelDate, IAtsUser cancelBy, IAtsChangeSet changes) throws OseeCoreException {
        workItem.getLog().addLog(LogType.StateComplete, fromState.getName(), Strings.isValid((String)reason) ? reason : "", cancelDate, cancelBy.getUserId());
        if (this.attrResolver.isAttributeTypeValid(workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy)) {
            this.attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CompletedBy, (Object)cancelBy.getUserId(), changes);
            this.attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CompletedDate, (Object)cancelDate, changes);
            this.attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CompletedFromState, (Object)fromState.getName(), changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    public static void logWorkflowUnCompletedEvent(IAtsWorkItem workItem, IAtsStateDefinition toState, IAtsChangeSet changes, IAttributeResolver attrResolver) throws OseeCoreException {
        if (attrResolver.isAttributeTypeValid(workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy)) {
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeId)AtsAttributeTypes.CompletedBy, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeId)AtsAttributeTypes.CompletedDate, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeId)AtsAttributeTypes.CompletedFromState, changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    private static void validateUpdatePercentComplete(IAtsWorkItem workItem, IAtsStateDefinition toState, IAtsChangeSet changes) {
        IAtsStateManager stateMgr = workItem.getStateMgr();
        Integer percent = stateMgr.getPercentCompleteValue();
        if (percent == null) {
            percent = 0;
        }
        if (toState.getStateType().isCompletedOrCancelledState() && percent != 100) {
            stateMgr.setPercentCompleteValue(Integer.valueOf(100));
            changes.add((Object)workItem);
        } else if (toState.getStateType().isWorkingState() && percent == 100) {
            stateMgr.setPercentCompleteValue(Integer.valueOf(0));
            changes.add((Object)workItem);
        }
    }

    private void logStateCompletedEvent(IAtsWorkItem workItem, String fromStateName, String reason, Date date, IAtsUser user) throws OseeCoreException {
        workItem.getLog().addLog(LogType.StateComplete, fromStateName, Strings.isValid((String)reason) ? reason : "", date, user.getUserId());
    }

    public static void logStateStartedEvent(IAtsWorkItem workItem, IStateToken state, Date date, IAtsUser user) throws OseeCoreException {
        workItem.getLog().addLog(LogType.StateEntered, state.getName(), "", date, user.getUserId());
    }

    public IAtsUser getTransitionAsUser() throws OseeCoreException {
        IAtsUser user = this.helper.getTransitionUser();
        if (user == null) {
            user = this.userService.getCurrentUser();
        }
        return user;
    }

    public Date getTransitionOnDate() {
        if (this.transitionOnDate == null) {
            return new Date();
        }
        return this.transitionOnDate;
    }

    public void setTransitionOnDate(Date transitionOnDate) {
        this.transitionOnDate = transitionOnDate;
    }

    public List<? extends IAtsUser> getToAssignees(IAtsWorkItem workItem, IAtsStateDefinition toState) throws OseeCoreException {
        ArrayList<IAtsUser> toAssignees = new ArrayList<IAtsUser>();
        if (toState.getStateType().isWorkingState()) {
            Collection requestedAssignees = this.helper.getToAssignees(workItem);
            if (requestedAssignees != null) {
                for (IAtsUser user : requestedAssignees) {
                    toAssignees.add(user);
                }
            }
            if (toAssignees.contains(AtsCoreUsers.UNASSIGNED_USER)) {
                toAssignees.remove(AtsCoreUsers.UNASSIGNED_USER);
                toAssignees.add(this.getTransitionAsUser());
            }
            if (toAssignees.isEmpty()) {
                if (this.helper.isSystemUser()) {
                    toAssignees.add(AtsCoreUsers.UNASSIGNED_USER);
                } else {
                    toAssignees.add(this.getTransitionAsUser());
                }
            }
        }
        return toAssignees;
    }

    public TransitionResults handleAllAndPersist() {
        TransitionResults result = this.handleAll();
        if (result.isEmpty()) {
            this.helper.getChangeSet().execute();
        }
        return result;
    }

    public void changesStored(IAtsChangeSet changes) {
        for (ITransitionListener listener : this.helper.getTransitionListeners()) {
            listener.transitionPersisted(this.helper.getWorkItems(), this.workItemFromStateMap, this.helper.getToStateName());
        }
    }
}

