/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.transition;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workdef.ITransitionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;

public abstract class TransitionHelperAdapter
implements ITransitionHelper {
    private final IAtsServices services;
    private IAtsUser transitionUser;
    private boolean workflowsReloaded = false;

    public TransitionHelperAdapter(IAtsServices services) {
        this.services = services;
    }

    public boolean isPrivilegedEditEnabled() {
        return false;
    }

    public boolean isOverrideTransitionValidityCheck() {
        return false;
    }

    public boolean isReload() {
        return true;
    }

    public boolean isOverrideAssigneeCheck() {
        return false;
    }

    public boolean isWorkingBranchInWork(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        return this.services.getBranchService().isWorkingBranchInWork(teamWf);
    }

    public boolean isBranchInCommit(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        return this.services.getBranchService().isBranchInCommit(teamWf);
    }

    public boolean isSystemUser() throws OseeCoreException {
        return AtsCoreUsers.isAtsCoreUser(this.getTransitionUser());
    }

    public boolean isSystemUserAssingee(IAtsWorkItem workItem) throws OseeCoreException {
        return workItem.getStateMgr().getAssignees().contains(AtsCoreUsers.ANONYMOUS_USER) || workItem.getStateMgr().getAssignees().contains(AtsCoreUsers.SYSTEM_USER);
    }

    public boolean isExecuteChanges() {
        return false;
    }

    public IAtsUser getTransitionUser() throws OseeStateException, OseeCoreException {
        IAtsUser user = this.transitionUser;
        if (user == null) {
            user = this.services.getUserService().getCurrentUser();
        }
        return user;
    }

    public void setTransitionUser(IAtsUser user) throws OseeCoreException {
        this.transitionUser = user;
    }

    public abstract Collection<? extends IAtsWorkItem> getWorkItems();

    public void handleWorkflowReload(TransitionResults results) {
        if (!this.workflowsReloaded) {
            LinkedList<IAtsWorkItem> workItemsToReload = new LinkedList<IAtsWorkItem>();
            for (IAtsWorkItem iAtsWorkItem : this.getWorkItems()) {
                boolean changed = this.services.getStoreService().isChangedInDb(iAtsWorkItem);
                if (!changed) continue;
                workItemsToReload.add(iAtsWorkItem);
            }
            if (!workItemsToReload.isEmpty()) {
                this.services.getStoreService().reload(workItemsToReload);
            }
            for (IAtsWorkItem iAtsWorkItem : this.getWorkItems()) {
                if (!this.services.getStoreService().isDeleted((IAtsObject)iAtsWorkItem)) continue;
                results.addResult(iAtsWorkItem, (ITransitionResult)TransitionResult.WORKITEM_DELETED);
            }
            this.workflowsReloaded = true;
        }
    }
}

