/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.transition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemService;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionListener;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelperAdapter;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class TransitionHelper
extends TransitionHelperAdapter {
    private final String cancellationReason;
    private final Collection<? extends IAtsWorkItem> workItems;
    private final String name;
    private TransitionOption[] transitionOption;
    private final Collection<? extends IAtsUser> toAssignees;
    private String toStateName;
    private final IAtsChangeSet changes;
    private boolean executeChanges = false;
    private final IAtsWorkItemService workItemService;
    private final IAtsServices services;

    public TransitionHelper(String name, Collection<? extends IAtsWorkItem> workItems, String toStateName, Collection<? extends IAtsUser> toAssignees, String cancellationReason, IAtsChangeSet changes, IAtsServices services, TransitionOption ... transitionOption) {
        super(services);
        this.services = services;
        this.workItemService = services.getWorkItemService();
        this.name = name;
        this.workItems = workItems;
        this.toStateName = toStateName;
        this.toAssignees = toAssignees;
        this.cancellationReason = cancellationReason;
        this.changes = changes;
        this.transitionOption = transitionOption;
    }

    @Override
    public boolean isPrivilegedEditEnabled() {
        return Arrays.asList(this.transitionOption).contains(TransitionOption.PrivilegedEditEnabled);
    }

    @Override
    public boolean isOverrideAssigneeCheck() {
        return Arrays.asList(this.transitionOption).contains(TransitionOption.OverrideAssigneeCheck);
    }

    @Override
    public boolean isReload() {
        return !Arrays.asList(this.transitionOption).contains(TransitionOption.OverrideReload);
    }

    @Override
    public boolean isOverrideTransitionValidityCheck() {
        return Arrays.asList(this.transitionOption).contains(TransitionOption.OverrideTransitionValidityCheck);
    }

    @Override
    public Collection<? extends IAtsWorkItem> getWorkItems() {
        return this.workItems;
    }

    public Result getCompleteOrCancellationReason() {
        if (Strings.isValid((String)this.cancellationReason)) {
            return new Result(true, this.cancellationReason);
        }
        return Result.FalseResult;
    }

    public String getName() {
        return this.name;
    }

    public Collection<? extends IAtsUser> getToAssignees(IAtsWorkItem workItem) throws OseeCoreException {
        return this.toAssignees;
    }

    public Result handleExtraHoursSpent(IAtsChangeSet changes) {
        return Result.TrueResult;
    }

    public String getToStateName() {
        return this.toStateName;
    }

    public void addTransitionOption(TransitionOption transitionOption) {
        ArrayList<TransitionOption> options = new ArrayList<TransitionOption>(Arrays.asList(this.transitionOption));
        if (!options.contains(transitionOption)) {
            options.add(transitionOption);
        }
        this.transitionOption = options.toArray(new TransitionOption[options.size()]);
    }

    public void removeTransitionOption(TransitionOption transitionOption) {
        ArrayList<TransitionOption> options = new ArrayList<TransitionOption>(Arrays.asList(this.transitionOption));
        if (options.contains(transitionOption)) {
            options.remove(transitionOption);
        }
        this.transitionOption = options.toArray(new TransitionOption[options.size()]);
    }

    public void setToStateName(String toStateName) {
        this.toStateName = toStateName;
    }

    public IAtsChangeSet getChangeSet() {
        return this.changes;
    }

    @Override
    public boolean isExecuteChanges() {
        return this.executeChanges;
    }

    public void setExecuteChanges(boolean executeChanges) {
        this.executeChanges = executeChanges;
    }

    public Collection<ITransitionListener> getTransitionListeners() {
        try {
            return this.workItemService.getTransitionListeners();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(TransitionHelper.class, (Level)Level.SEVERE, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public IAtsServices getServices() {
        return this.services;
    }

    public TransitionOption[] getTransitionOptions() {
        return this.transitionOption;
    }
}

