/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.transition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.team.ITeamWorkflowProvider;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.IAtsTransitionManager;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.TeamWorkflowProviders;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TransitionFactory;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TeamWorkFlowManager {
    private final IAtsTeamWorkflow teamWf;
    private final TransitionOption[] transitionOptions;
    private final IAtsServices services;

    public TeamWorkFlowManager(IAtsTeamWorkflow teamWf, IAtsServices services, TransitionOption ... transitionOptions) {
        this.teamWf = teamWf;
        this.services = services;
        this.transitionOptions = transitionOptions;
    }

    public Result transitionTo(TeamState toState, IAtsUser user, boolean popup, IAtsChangeSet changes) throws OseeCoreException {
        return this.transitionTo(toState, user, Arrays.asList(user), popup, changes);
    }

    public Result transitionTo(TeamState toState, IAtsUser currentStateUser, Collection<IAtsUser> transitionToAssignees, boolean popup, IAtsChangeSet changes) throws OseeCoreException {
        Result result;
        Conditions.checkNotNull((Object)currentStateUser, (String)"currentStateUser");
        Conditions.checkNotNullOrEmpty(transitionToAssignees, (String)"transitionToAssignees");
        Date date = new Date();
        if (toState == TeamState.Endorse) {
            if (!this.teamWf.getStateMgr().getCurrentStateName().equals(TeamState.Endorse.getName())) {
                return new Result("Workflow current state [%s] past desired Endorse state", new Object[]{this.teamWf.getStateMgr().getCurrentStateName()});
            }
            return Result.TrueResult;
        }
        if (this.teamWf.getStateMgr().isInState((IStateToken)TeamState.Endorse) && (result = this.processEndorseState(popup, this.teamWf, currentStateUser, transitionToAssignees, date, changes)).isFalse()) {
            return result;
        }
        if (toState == TeamState.Analyze) {
            return Result.TrueResult;
        }
        if (this.teamWf.getStateMgr().isInState((IStateToken)TeamState.Analyze) && (result = this.processAnalyzeState(popup, this.teamWf, currentStateUser, transitionToAssignees, date, changes)).isFalse()) {
            return result;
        }
        if (toState == TeamState.Authorize) {
            return Result.TrueResult;
        }
        if (this.teamWf.getStateMgr().isInState((IStateToken)TeamState.Authorize) && (result = this.processAuthorizeState(popup, this.teamWf, currentStateUser, transitionToAssignees, date, changes)).isFalse()) {
            return result;
        }
        if (toState == TeamState.Implement) {
            return Result.TrueResult;
        }
        if (this.teamWf.getStateMgr().isInState((IStateToken)TeamState.Implement) && (result = this.transitionToState(popup, this.teamWf, TeamState.Completed, transitionToAssignees, changes, this.services)).isFalse()) {
            return result;
        }
        return Result.TrueResult;
    }

    private Result processAuthorizeState(boolean popup, IAtsTeamWorkflow teamWf, IAtsUser currentStateUser, Collection<IAtsUser> transitionToAssignees, Date date, IAtsChangeSet changes) throws OseeCoreException {
        Result result = this.setAuthorizeData(popup, 100, 0.2, currentStateUser, date);
        if (result.isFalse()) {
            return result;
        }
        result = this.transitionToState(popup, teamWf, TeamState.Implement, transitionToAssignees, changes, this.services);
        if (result.isFalse()) {
            return result;
        }
        return Result.TrueResult;
    }

    private Result processAnalyzeState(boolean popup, IAtsTeamWorkflow teamWf, IAtsUser currentStateUser, Collection<IAtsUser> transitionToAssignees, Date date, IAtsChangeSet changes) throws OseeCoreException {
        Result result = this.setAnalyzeData(popup, null, null, 100, 0.2, currentStateUser, date);
        if (result.isFalse()) {
            return result;
        }
        result = this.transitionToState(popup, teamWf, TeamState.Authorize, transitionToAssignees, changes, this.services);
        if (result.isFalse()) {
            return result;
        }
        return Result.TrueResult;
    }

    private Result processEndorseState(boolean popup, IAtsTeamWorkflow teamWf, IAtsUser currentStateUser, Collection<IAtsUser> transitionToAssignees, Date date, IAtsChangeSet changes) throws OseeCoreException {
        Result result = this.setEndorseData(popup, null, 100, 0.2, currentStateUser, date);
        if (result.isFalse()) {
            return result;
        }
        result = this.transitionToState(popup, teamWf, TeamState.Analyze, transitionToAssignees, changes, this.services);
        if (result.isFalse()) {
            return result;
        }
        return Result.TrueResult;
    }

    private Result transitionToState(boolean popup, IAtsTeamWorkflow teamWf, IStateToken toState, Collection<IAtsUser> transitionToAssignees, IAtsChangeSet changes, IAtsServices services) {
        TransitionHelper helper = new TransitionHelper("Transition to " + toState.getName(), Arrays.asList(teamWf), toState.getName(), transitionToAssignees, null, changes, services, this.transitionOptions);
        IAtsTransitionManager transitionMgr = TransitionFactory.getTransitionManager(helper);
        TransitionResults results = transitionMgr.handleAll();
        if (results.isEmpty()) {
            return Result.TrueResult;
        }
        return new Result("Transition Error %s", new Object[]{results.toString()});
    }

    public Result setEndorseData(boolean popup, String propRes, int statePercentComplete, double stateHoursSpent, IAtsUser user, Date date) throws OseeCoreException {
        Result result;
        if (!this.teamWf.getStateMgr().isInState((IStateToken)TeamState.Endorse) && (result = new Result("Action not in Endorse state")).isFalse() && popup) {
            return result;
        }
        this.teamWf.getStateMgr().setMetrics((IStateToken)TeamState.Endorse, stateHoursSpent, statePercentComplete, true, user, date);
        return Result.TrueResult;
    }

    public Result setAnalyzeData(boolean popup, String problem, String propRes, int statePercentComplete, double stateHoursSpent, IAtsUser user, Date date) throws OseeCoreException {
        Result result;
        if (!this.teamWf.getStateMgr().isInState((IStateToken)TeamState.Analyze) && (result = new Result("Action not in Analyze state")).isFalse() && popup) {
            return result;
        }
        this.teamWf.getStateMgr().setMetrics((IStateToken)TeamState.Analyze, stateHoursSpent, statePercentComplete, true, user, date);
        return Result.TrueResult;
    }

    public Result setAuthorizeData(boolean popup, int statePercentComplete, double stateHoursSpent, IAtsUser user, Date date) throws OseeCoreException {
        Result result;
        if (!this.teamWf.getStateMgr().isInState((IStateToken)TeamState.Authorize) && (result = new Result("Action not in Authorize state")).isFalse() && popup) {
            return result;
        }
        this.teamWf.getStateMgr().setMetrics((IStateToken)TeamState.Authorize, stateHoursSpent, statePercentComplete, true, user, date);
        return Result.TrueResult;
    }

    public Result setImplementData(boolean popup, String resolution, int statePercentComplete, double stateHoursSpent, IAtsUser user, Date date) throws OseeCoreException {
        Result result;
        if (!this.teamWf.getStateMgr().isInState((IStateToken)TeamState.Implement) && (result = new Result("Action not in Implement state")).isFalse() && popup) {
            return result;
        }
        this.teamWf.getStateMgr().setMetrics((IStateToken)TeamState.Implement, stateHoursSpent, statePercentComplete, true, user, date);
        return Result.TrueResult;
    }

    public static String getArtifactTypeShortName(IAtsWorkItem teamWf) {
        for (ITeamWorkflowProvider atsTeamWorkflow : TeamWorkflowProviders.getTeamWorkflowProviders()) {
            String typeName = atsTeamWorkflow.getArtifactTypeShortName((IAtsTeamWorkflow)teamWf.getStoreObject());
            if (!Strings.isValid((String)typeName)) continue;
            return typeName;
        }
        return null;
    }
}

