/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public abstract class StateTypeAdapter
implements IStateToken {
    private final StateType StateType;
    private static CompositeKeyHashMap<Class<?>, String, StateTypeAdapter> classAndNameToPage = new CompositeKeyHashMap();
    private static final Map<StateTypeAdapter, Integer> pageToOrdinal = new HashMap<StateTypeAdapter, Integer>(10);
    private static final Map<Class<?>, List<StateTypeAdapter>> classToPages = new HashMap();
    private static final CountingMap<Class<?>> classToOrdinalCount = new CountingMap(20);
    private String description;
    private final String pageName;

    public StateTypeAdapter(Class<?> clazz, String pageName, StateType StateType2) {
        this.pageName = pageName;
        this.StateType = StateType2;
        classAndNameToPage.put(clazz, (Object)pageName, (Object)this);
        classToOrdinalCount.put(clazz);
        pageToOrdinal.put(this, classToOrdinalCount.get(clazz));
    }

    public int ordinal() {
        return pageToOrdinal.get(this);
    }

    public static <T> T valueOfPage(Class<?> clazz, String pageName) {
        return (T)classAndNameToPage.get(clazz, (Object)pageName);
    }

    public static synchronized <T> List<T> pages(Class<?> clazz) {
        if (classToPages.get(clazz) == null) {
            HashSet<StateTypeAdapter> pages = new HashSet<StateTypeAdapter>();
            for (StateTypeAdapter page : pageToOrdinal.keySet()) {
                if (!page.getClass().isAssignableFrom(clazz)) continue;
                pages.add(page);
            }
            ArrayList<StateTypeAdapter> pagesOrdered = new ArrayList<StateTypeAdapter>();
            int x = 1;
            while (x <= pages.size()) {
                for (StateTypeAdapter page : pages) {
                    if (page.ordinal() != x) continue;
                    pagesOrdered.add(page);
                }
                ++x;
            }
            classToPages.put(clazz, pagesOrdered);
        }
        return Collections.castAll((Collection)classToPages.get(clazz));
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.pageName;
    }

    public StateType getStateType() {
        return this.StateType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return String.format("[%s][%s]", this.getName(), this.getStateType().name());
    }
}

