/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.state;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.WorkState;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.api.workflow.state.IAtsWorkStateFactory;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class StateManagerUtility {
    public static void initializeStateMachine(IAtsStateManager stateMgr, IStateToken workPage, List<? extends IAtsUser> assignees, IAtsUser currentUser, IAtsChangeSet changes) throws OseeCoreException {
        stateMgr.createState(workPage.getName());
        stateMgr.setCurrentStateName(workPage.getName());
        if (assignees == null) {
            assignees = new LinkedList<IAtsUser>();
        }
        if (workPage.getStateType().isWorkingState()) {
            if (assignees.isEmpty()) {
                if (!currentUser.equals(AtsCoreUsers.SYSTEM_USER)) {
                    stateMgr.setAssignees(Arrays.asList(currentUser));
                } else {
                    stateMgr.setAssignee(AtsCoreUsers.UNASSIGNED_USER);
                }
            } else {
                stateMgr.setAssignees(assignees);
            }
        }
    }

    public static Result isDirtyResult(IAtsWorkItem workItem, IAtsStateManager stateMgr, IAttributeResolver attrResolver, IAtsWorkStateFactory workStateFactory) throws OseeCoreException {
        if (attrResolver.getAttributeCount(workItem, (AttributeTypeId)AtsAttributeTypes.CurrentState) == 0) {
            return new Result(true, "StateManager: Current State new");
        }
        if (!workStateFactory.toStoreStr(stateMgr, stateMgr.getCurrentStateName()).equals(attrResolver.getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CurrentState, null))) {
            return new Result(true, "StateManager: Current State modified");
        }
        for (String stateName : stateMgr.getVisitedStateNames()) {
            if (stateName.equals(stateMgr.getCurrentStateName())) continue;
            boolean found = false;
            for (String storedStateXml : attrResolver.getAttributesToStringList((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.State)) {
                WorkState storedState = workStateFactory.fromStoreStr(storedStateXml);
                if (!stateName.equals(storedState.getName())) continue;
                found = true;
                String currentStateXml = workStateFactory.toStoreStr(stateMgr, stateName);
                if (currentStateXml.equals(storedStateXml)) continue;
                return new Result(true, String.format("StateManager: State [%s] modified was [%s] is [%s]", stateName, storedStateXml, currentStateXml));
            }
            if (found) continue;
            return new Result(true, String.format("StateManager: State [%s] added", stateName));
        }
        return Result.FalseResult;
    }
}

