/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.note;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workflow.note.IAtsWorkItemNotes;
import org.eclipse.osee.ats.api.workflow.note.NoteItem;
import org.eclipse.osee.ats.api.workflow.note.NoteType;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.core.workflow.note.INoteStorageProvider;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AtsWorkItemNotes
implements IAtsWorkItemNotes {
    private boolean enabled = true;
    private final INoteStorageProvider storeProvder;
    public static final String LOG_ITEM_TAG = "Item";
    public static final String ATS_NOTE_TAG = "AtsNote";
    private final IAtsServices services;

    public AtsWorkItemNotes(INoteStorageProvider storeProvder, IAtsServices services) {
        this.storeProvder = storeProvder;
        this.services = services;
    }

    public void addNote(NoteType type, String state, String msg, IAtsUser user) {
        this.addNote(type, state, msg, new Date(), user);
    }

    public void addNoteItem(NoteItem noteItem) {
        this.addNote(noteItem.getType(), noteItem.getState(), noteItem.getMsg(), noteItem.getDate(), noteItem.getUser());
    }

    public void addNote(NoteType type, String state, String msg, Date date, IAtsUser user) {
        if (!this.enabled) {
            return;
        }
        NoteItem logItem = new NoteItem(type, state, String.valueOf(date.getTime()), user, msg);
        List<NoteItem> logItems = this.getNoteItems();
        if (logItems.isEmpty()) {
            logItems = Arrays.asList(logItem);
        } else {
            logItems.add(logItem);
        }
        this.saveNoteItems(logItems);
    }

    public List<NoteItem> getNoteItems() {
        try {
            String xml = this.storeProvder.getNoteXml();
            if (Strings.isValid((String)xml)) {
                return AtsWorkItemNotes.fromXml(xml, this.storeProvder.getNoteId(), this.services);
            }
        }
        catch (Exception ex) {
            this.services.getLogger().error((Throwable)ex, "Error extracting note", new Object[0]);
        }
        return Collections.emptyList();
    }

    public void saveNoteItems(List<NoteItem> items) {
        try {
            String xml = AtsWorkItemNotes.toXml(items, this.services);
            this.storeProvder.saveNoteXml(xml);
        }
        catch (Exception ex) {
            this.services.getLogger().error((Throwable)ex, "Error saving note", new Object[0]);
        }
    }

    public String getTable(String state) {
        if (!this.storeProvder.isNoteable()) {
            return "";
        }
        ArrayList<NoteItem> showNotes = new ArrayList<NoteItem>();
        List<NoteItem> noteItems = this.getNoteItems();
        for (NoteItem li : noteItems) {
            if (state == null && li.getState().equals("")) {
                showNotes.add(li);
                continue;
            }
            if (state == null || !"ALL".equals(state) && !li.getState().equals(state)) continue;
            showNotes.add(li);
        }
        if (showNotes.isEmpty()) {
            return "";
        }
        return this.buildTable(showNotes);
    }

    private String buildTable(List<NoteItem> showNotes) {
        StringBuilder builder = new StringBuilder();
        builder.append(AHTML.beginMultiColumnTable((int)100, (int)1));
        builder.append(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Type", "State", "Message", "User", "Date")));
        DateFormat dateFormat = this.getDateFormat();
        for (NoteItem note : showNotes) {
            IAtsUser user = note.getUser();
            String name = "";
            if (user != null && !Strings.isValid((String)(name = user.getName()))) {
                name = user.getName();
            }
            builder.append(AHTML.addRowMultiColumnTable((String[])new String[]{String.valueOf(note.getType()), note.getState().isEmpty() ? "," : note.getState(), note.getMsg().equals("") ? "," : note.getMsg(), name, dateFormat.format(note.getDate())}));
        }
        builder.append(AHTML.endMultiColumnTable());
        return builder.toString();
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/dd/yyyy h:mm a", Locale.US);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static List<NoteItem> fromXml(String xml, String atsId, IAtsServices services) {
        ArrayList<NoteItem> logItems;
        block5: {
            logItems = new ArrayList<NoteItem>();
            try {
                if (!Strings.isValid((String)xml)) break block5;
                NodeList nodes = Jaxp.readXmlDocument((String)xml).getElementsByTagName(LOG_ITEM_TAG);
                int i = 0;
                while (i < nodes.getLength()) {
                    NoteItem item;
                    Element element = (Element)nodes.item(i);
                    try {
                        IAtsUser user = services.getUserService().getUserById(element.getAttribute("userId"));
                        item = new NoteItem(element.getAttribute("type"), element.getAttribute("state"), element.getAttribute("date"), user, element.getAttribute("msg"));
                        logItems.add(item);
                    }
                    catch (UserNotInDatabase ex) {
                        services.getLogger().error((Throwable)ex, "Error parsing notes for [%s]", new Object[]{atsId});
                        item = new NoteItem(element.getAttribute("type"), element.getAttribute("state"), element.getAttribute("date"), AtsCoreUsers.ANONYMOUS_USER, element.getAttribute("msg"));
                        logItems.add(item);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                services.getLogger().error((Throwable)ex, "Error reading AtsNote", new Object[0]);
            }
        }
        return logItems;
    }

    public static String toXml(List<NoteItem> items, IAtsServices services) {
        try {
            Document doc = Jaxp.newDocumentNamespaceAware();
            Element rootElement = doc.createElement(ATS_NOTE_TAG);
            doc.appendChild(rootElement);
            for (NoteItem item : items) {
                Element element = doc.createElement(LOG_ITEM_TAG);
                element.setAttribute("type", item.getType().name());
                element.setAttribute("state", item.getState());
                element.setAttribute("date", String.valueOf(item.getDate().getTime()));
                element.setAttribute("userId", item.getUser().getUserId());
                element.setAttribute("msg", item.getMsg());
                rootElement.appendChild(element);
            }
            return Jaxp.getDocumentXml((Document)doc);
        }
        catch (Exception ex) {
            services.getLogger().error((Throwable)ex, "Error writing AtsNote", new Object[0]);
            return null;
        }
    }
}

