/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.note;

import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.core.workflow.note.INoteStorageProvider;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class ArtifactNote
implements INoteStorageProvider {
    private final IAtsWorkItem workItem;
    private final IAtsServices services;

    public ArtifactNote(IAtsWorkItem workItem, IAtsServices services) {
        this.workItem = workItem;
        this.services = services;
    }

    @Override
    public String getNoteXml() {
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.StateNotes, (Object)"");
    }

    @Override
    public Result saveNoteXml(String xml) {
        try {
            this.services.getAttributeResolver().setSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.StateNotes, (Object)xml);
            return Result.TrueResult;
        }
        catch (OseeCoreException ex) {
            this.services.getLogger().error((Throwable)ex, "Error saving note xml", new Object[0]);
            return new Result(false, "saveLogXml exception " + ex.getLocalizedMessage());
        }
    }

    @Override
    public String getNoteTitle() {
        return "History for \"" + this.services.getStoreService().getArtifactType((ArtifactId)this.workItem.getStoreObject()).getName() + "\" - " + this.getNoteId() + " - titled \"" + this.workItem.getName() + "\"";
    }

    @Override
    public String getNoteId() {
        return this.workItem.getAtsId();
    }

    @Override
    public boolean isNoteable() {
        return this.services.getStoreService().isAttributeTypeValid((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.StateNotes);
    }
}

