/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;

public class WorkflowManagerCore {
    public static boolean isEditable(IAtsUser user, IAtsWorkItem workItem, IAtsStateDefinition stateDef, boolean privilegedEditEnabled, IAtsUserService userService) throws OseeCoreException {
        return WorkflowManagerCore.isEditable(workItem, stateDef, privilegedEditEnabled, user, userService.isAtsAdmin(user));
    }

    public static boolean isEditable(IAtsWorkItem workItem, IAtsStateDefinition stateDef, boolean privilegedEditEnabled, IAtsUser currentUser, boolean isAtsAdmin) throws OseeCoreException {
        WorkflowManagerCore wmc = new WorkflowManagerCore();
        return wmc.isWorkItemEditable(workItem, stateDef, privilegedEditEnabled, currentUser, isAtsAdmin);
    }

    protected boolean isWorkItemEditable(IAtsWorkItem workItem, IAtsStateDefinition stateDef, boolean privilegedEditEnabled, IAtsUser currentUser, boolean isAtsAdmin) throws OseeCoreException {
        return !(stateDef != null && !workItem.getStateDefinition().getName().equals(stateDef.getName()) || !workItem.getStateDefinition().hasRule(RuleDefinitionOption.AllowEditToAll.name()) && !this.teamDefHasRule(workItem, RuleDefinitionOption.AllowEditToAll) && !privilegedEditEnabled && !workItem.getAssignees().contains(currentUser) && !isAtsAdmin);
    }

    protected boolean teamDefHasRule(IAtsWorkItem workItem, RuleDefinitionOption option) {
        boolean hasRule = false;
        IAtsTeamWorkflow teamWf = null;
        try {
            if (workItem instanceof IAtsTeamWorkflow) {
                teamWf = (IAtsTeamWorkflow)workItem;
            } else if (workItem instanceof IAtsAbstractReview) {
                teamWf = ((IAtsAbstractReview)workItem).getParentTeamWorkflow();
            }
            if (teamWf != null) {
                hasRule = teamWf.getTeamDefinition().hasRule(option.name());
            }
        }
        catch (Exception ex) {
            OseeLog.log(WorkflowManagerCore.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return hasRule;
    }
}

