/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.IWorkDefinitionMatch;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.core.model.impl.AtsObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;

public class WorkItem
extends AtsObject
implements IAtsWorkItem {
    protected final ArtifactToken artifact;
    private IAtsStateManager stateMgr;
    private IAtsLog atsLog;
    private IWorkDefinitionMatch match;
    protected final IAtsServices services;
    protected final Log logger;

    public WorkItem(Log logger, IAtsServices services, ArtifactToken artifact) {
        super(artifact.getName(), artifact.getId());
        this.logger = logger;
        this.services = services;
        this.artifact = artifact;
        this.setStoreObject(artifact);
    }

    @Override
    public String getDescription() {
        try {
            return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.Description, (Object)"");
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error getting description for artifact[%s]", new Object[]{this.artifact});
            return "exception: " + ex.getLocalizedMessage();
        }
    }

    public List<IAtsUser> getAssignees() throws OseeCoreException {
        return this.getStateMgr().getAssignees();
    }

    public String getAtsId() {
        try {
            return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.AtsId, (Object)String.valueOf(this.getId()));
        }
        catch (OseeCoreException oseeCoreException) {
            return null;
        }
    }

    public void setAtsId(String atsId, IAtsChangeSet changes) throws OseeCoreException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public IAtsTeamWorkflow getParentTeamWorkflow() throws OseeCoreException {
        Collection results;
        ArtifactToken teamArt = null;
        if (this.isTeamWorkflow()) {
            teamArt = this.artifact;
        } else if (this.isReview()) {
            Collection results2 = this.services.getRelationResolver().getRelated((ArtifactId)this.artifact, AtsRelationTypes.TeamWorkflowToReview_Team);
            if (!results2.isEmpty()) {
                teamArt = (ArtifactId)results2.iterator().next();
            }
        } else if (this.isTask() && !(results = this.services.getRelationResolver().getRelated((ArtifactId)this.artifact, AtsRelationTypes.TeamWfToTask_TeamWf)).isEmpty()) {
            teamArt = (ArtifactId)results.iterator().next();
        }
        return this.services.getWorkItemFactory().getTeamWf((ArtifactId)teamArt);
    }

    public IAtsAction getParentAction() {
        Collection results;
        ArtifactId actionArt = null;
        IAtsTeamWorkflow teamWf = this.getParentTeamWorkflow();
        if (teamWf != null && !(results = this.services.getRelationResolver().getRelated((ArtifactId)teamWf.getStoreObject(), AtsRelationTypes.ActionToWorkflow_Action)).isEmpty()) {
            actionArt = (ArtifactId)results.iterator().next();
        }
        return this.services.getWorkItemFactory().getAction(actionArt);
    }

    public boolean isReview() {
        return this instanceof IAtsAbstractReview;
    }

    public boolean isGoal() {
        return this instanceof IAtsGoal;
    }

    public IAtsStateManager getStateMgr() {
        if (this.stateMgr == null) {
            try {
                this.stateMgr = this.services.getStateFactory().getStateManager((IAtsWorkItem)this, true);
            }
            catch (OseeCoreException ex) {
                this.logger.error((Throwable)ex, "Error getting stateManager for artifact[%s]", new Object[]{this.artifact});
            }
        }
        return this.stateMgr;
    }

    public void setStateManager(IAtsStateManager stateMgr) {
        Conditions.assertNotNull((Object)stateMgr, (String)"stateMgr", (Object[])new Object[0]);
        this.stateMgr = stateMgr;
    }

    public IAtsLog getLog() {
        if (this.atsLog == null) {
            try {
                this.atsLog = this.services.getLogFactory().getLogLoaded((IAtsWorkItem)this, this.services.getAttributeResolver());
            }
            catch (OseeCoreException ex) {
                this.logger.error((Throwable)ex, "Error getting Log for artifact[%s]", new Object[]{this.artifact});
            }
        }
        return this.atsLog;
    }

    public IAtsWorkDefinition getWorkDefinition() {
        if (this.match == null) {
            this.match = this.getWorkDefinitionMatch();
            if (this.match == null) {
                return null;
            }
            if (!this.match.isMatched()) {
                this.logger.error("Error getting work definition for artifact[%s] - using match [%s]", new Object[]{this.artifact, this.match});
                return null;
            }
        }
        return this.match.getWorkDefinition();
    }

    public IWorkDefinitionMatch getWorkDefinitionMatch() {
        if (this.match == null) {
            try {
                this.match = this.services.getWorkDefinitionAdmin().getWorkDefinition((IAtsWorkItem)this);
            }
            catch (Exception ex) {
                this.logger.error("Error getting work definition match for artifact[%s]: Exception %s", new Object[]{this.artifact, ex.getLocalizedMessage()});
            }
        }
        return this.match;
    }

    public IAtsStateDefinition getStateDefinition() {
        String currentStateName = this.getStateMgr().getCurrentStateName();
        if (currentStateName == null) {
            return null;
        }
        return this.getWorkDefinition().getStateByName(currentStateName);
    }

    public IAtsStateDefinition getStateDefinitionByName(String name) {
        return this.getWorkDefinition().getStateByName(name);
    }

    public boolean isTask() {
        return this instanceof IAtsTask;
    }

    public boolean isTeamWorkflow() {
        return this instanceof IAtsTeamWorkflow;
    }

    @Override
    public ArtifactToken getStoreObject() {
        return this.artifact;
    }

    public IAtsUser getCreatedBy() {
        String userId = (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CreatedBy, null);
        return this.services.getUserService().getUserById(userId);
    }

    public Date getCreatedDate() {
        return (Date)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CreatedDate, null);
    }

    public IAtsUser getCompletedBy() {
        String userId = (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CompletedBy, null);
        return this.services.getUserService().getUserById(userId);
    }

    public IAtsUser getCancelledBy() {
        String userId = (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CancelledBy, null);
        return this.services.getUserService().getUserById(userId);
    }

    public String getCompletedFromState() {
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CompletedFromState, null);
    }

    public String getCancelledFromState() {
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CancelledFromState, null);
    }

    public String getArtifactTypeName() {
        return this.artifact.getArtifactType().getName();
    }

    public Date getCompletedDate() {
        return (Date)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CompletedDate, null);
    }

    public Date getCancelledDate() {
        return (Date)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CancelledDate, null);
    }

    public String getCancelledReason() {
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CancelledReason, null);
    }

    public boolean isInWork() {
        return this.getStateMgr().getStateType().isInWork();
    }

    public boolean isCompleted() {
        return ((String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CurrentStateType, (Object)"")).equals(StateType.Completed.name());
    }

    public boolean isCompletedOrCancelled() {
        return this.isCompleted() || this.isCancelled();
    }

    public boolean isCancelled() {
        return ((String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.CurrentStateType, (Object)"")).equals(StateType.Cancelled.name());
    }

    public List<IAtsUser> getImplementers() throws OseeCoreException {
        return this.services.getImplementerService().getImplementers((IAtsObject)this);
    }

    public boolean isDecisionReview() {
        return this instanceof IAtsDecisionReview;
    }

    public boolean isPeerReview() {
        return this instanceof IAtsPeerToPeerReview;
    }

    @Override
    public boolean isOfType(ArtifactTypeId ... artifactTypes) {
        return this.services.getStoreService().isOfType((ArtifactId)this.getStoreObject(), artifactTypes);
    }

    public void clearCaches() {
        this.stateMgr = null;
        this.atsLog = null;
        this.match = null;
    }
}

