/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItemService;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.team.ITeamWorkflowProvider;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemService;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.api.workflow.note.IAtsWorkItemNotes;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionListener;
import org.eclipse.osee.ats.core.ai.ActionableItemManager;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.validator.AtsXWidgetValidateManager;
import org.eclipse.osee.ats.core.workflow.TeamWorkflowProviders;
import org.eclipse.osee.ats.core.workflow.note.ArtifactNote;
import org.eclipse.osee.ats.core.workflow.note.AtsWorkItemNotes;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsWorkItemServiceImpl
implements IAtsWorkItemService {
    private final ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy;
    private final IAtsServices services;
    private IAtsActionableItemService actionableItemService;

    public AtsWorkItemServiceImpl(IAtsServices services, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        this.services = services;
        this.teamWorkflowProvidersLazy = teamWorkflowProvidersLazy;
    }

    public IStateToken getCurrentState(IAtsWorkItem workItem) throws OseeCoreException {
        ArtifactId artifact = this.services.getArtifactResolver().get((IAtsObject)workItem);
        Conditions.checkNotNull((Object)artifact, (String)"workItem", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{workItem.toString()});
        return workItem.getStateDefinition();
    }

    public Collection<IAtsAbstractReview> getReviews(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        ArtifactId artifact = this.services.getArtifactResolver().get((IAtsObject)teamWf);
        Conditions.checkNotNull((Object)artifact, (String)"teamWf", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{teamWf.toString()});
        return this.services.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowToReview_Review, IAtsAbstractReview.class);
    }

    public Collection<IAtsAbstractReview> getReviews(IAtsTeamWorkflow teamWf, IStateToken state) throws OseeCoreException {
        ArtifactId artifact = this.services.getArtifactResolver().get((IAtsObject)teamWf);
        Conditions.checkNotNull((Object)artifact, (String)"teamWf", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{teamWf.toString()});
        LinkedList<IAtsAbstractReview> reviews = new LinkedList<IAtsAbstractReview>();
        for (IAtsAbstractReview review : this.services.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowToReview_Review, IAtsAbstractReview.class)) {
            if (!((String)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)review, (AttributeTypeId)AtsAttributeTypes.RelatedToState, (Object)"")).equals(state.getName())) continue;
            reviews.add(review);
        }
        return reviews;
    }

    public IAtsTeamWorkflow getFirstTeam(Object object) throws OseeCoreException {
        Collection<IAtsTeamWorkflow> related = this.getTeams(object);
        return related.isEmpty() ? null : related.iterator().next();
    }

    public Collection<IAtsTeamWorkflow> getTeams(Object object) {
        LinkedList<IAtsTeamWorkflow> teams = new LinkedList<IAtsTeamWorkflow>();
        if (object instanceof IAtsAction) {
            for (ArtifactId teamWfArt : this.services.getRelationResolver().getRelated((IAtsObject)((IAtsAction)object), AtsRelationTypes.ActionToWorkflow_WorkFlow)) {
                teams.add(this.services.getWorkItemFactory().getTeamWf(teamWfArt));
            }
        } else if (object instanceof ActionResult) {
            return Collections.castAll(AtsObjects.getArtifacts(((ActionResult)object).getTeamWfArts()));
        }
        return teams;
    }

    public void clearImplementersCache(IAtsWorkItem workItem) {
        this.services.clearImplementersCache(workItem);
    }

    public Collection<WidgetResult> validateWidgetTransition(IAtsWorkItem workItem, IAtsStateDefinition toStateDef) throws OseeStateException {
        return AtsXWidgetValidateManager.validateTransition(workItem, toStateDef, this.services);
    }

    public Collection<ITransitionListener> getTransitionListeners() {
        return this.services.getTransitionListeners();
    }

    public String getTargetedVersionStr(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        IAtsVersion targetedVersion = this.services.getVersionService().getTargetedVersionByTeamWf(teamWf);
        if (targetedVersion != null) {
            return targetedVersion.getName();
        }
        return "";
    }

    public String getArtifactTypeShortName(IAtsTeamWorkflow teamWf) {
        for (ITeamWorkflowProvider atsTeamWorkflow : this.teamWorkflowProvidersLazy.getProviders()) {
            String typeName = atsTeamWorkflow.getArtifactTypeShortName(teamWf);
            if (!Strings.isValid((String)typeName)) continue;
            return typeName;
        }
        return null;
    }

    public IAtsActionableItemService getActionableItemService() {
        if (this.actionableItemService == null) {
            this.actionableItemService = new ActionableItemManager(this.services.getAttributeResolver(), this.services.getStoreService(), this.services);
        }
        return this.actionableItemService;
    }

    public String getCombinedPcrId(IAtsWorkItem workItem) throws OseeCoreException {
        String id = "";
        for (ITeamWorkflowProvider provider : TeamWorkflowProviders.getTeamWorkflowProviders()) {
            try {
                String computedPcrId;
                if (!provider.isResponsibleFor(workItem) || !Strings.isValid((String)(computedPcrId = provider.getComputedPcrId(workItem)))) continue;
                id = computedPcrId;
            }
            catch (Exception ex) {
                this.services.getLogger().error((Throwable)ex, "Error with provider %s", new Object[]{provider.toString()});
            }
        }
        if (Strings.isInValid((String)id)) {
            String legacyPcrId = (String)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.LegacyPcrId, (Object)"");
            if (Strings.isValid((String)legacyPcrId)) {
                return String.format("%s - %s", workItem.getAtsId(), legacyPcrId);
            }
            id = workItem.getAtsId();
        }
        return id;
    }

    public IAtsWorkItemNotes getNotes(IAtsWorkItem workItem) {
        return new AtsWorkItemNotes(new ArtifactNote(workItem, this.services), this.services);
    }

    public ITeamWorkflowProvidersLazy getTeamWorkflowProviders() {
        return this.teamWorkflowProvidersLazy;
    }
}

