/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsImplementerService;
import org.eclipse.osee.ats.core.model.IActionGroup;
import org.eclipse.osee.ats.core.review.DecisionReviewState;
import org.eclipse.osee.ats.core.review.PeerToPeerReviewState;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsImplementersService
implements IAtsImplementerService {
    private final IAtsServices services;

    public AtsImplementersService(IAtsServices services) {
        this.services = services;
    }

    public String getImplementersStr(IAtsObject atsObject) throws OseeCoreException {
        List<IAtsUser> implementers = this.getImplementers(atsObject);
        return implementers.isEmpty() ? "" : AtsObjects.toString("; ", implementers);
    }

    public List<IAtsUser> getImplementers(IAtsObject atsObject) throws OseeCoreException {
        LinkedList<IAtsUser> implementers = new LinkedList<IAtsUser>();
        if (atsObject instanceof IActionGroup) {
            implementers.addAll(this.getActionGroupImplementers((IActionGroup)atsObject));
        } else if (atsObject instanceof IAtsWorkItem) {
            implementers.addAll(this.getWorkItemImplementers((IAtsWorkItem)atsObject));
        }
        implementers.remove(AtsCoreUsers.UNASSIGNED_USER);
        Collections.sort(implementers);
        return implementers;
    }

    public List<IAtsUser> getWorkItemImplementers(IAtsWorkItem workItem) throws OseeCoreException {
        ArrayList<IAtsUser> implementers = new ArrayList<IAtsUser>();
        if (workItem.isReview()) {
            this.getImplementers_fromReviews(workItem, implementers);
        }
        this.getImplementers_fromCompletedCancelledBy(workItem, implementers);
        this.getImplementers_fromCompletedCancelledFrom(workItem, implementers);
        return implementers;
    }

    public void getImplementers_fromCompletedCancelledFrom(IAtsWorkItem workItem, List<IAtsUser> implementers) throws OseeCoreException {
        String fromStateName = null;
        if (workItem.getStateMgr().getStateType().isCompleted()) {
            fromStateName = workItem.getCompletedFromState();
        } else if (workItem.getStateMgr().getStateType().isCancelled()) {
            fromStateName = workItem.getCancelledFromState();
        }
        if (Strings.isValid((String)fromStateName)) {
            for (IAtsUser user : workItem.getStateMgr().getAssigneesForState(fromStateName)) {
                if (implementers.contains(user)) continue;
                implementers.add(user);
            }
        }
    }

    public void getImplementers_fromCompletedCancelledBy(IAtsWorkItem workItem, List<IAtsUser> implementers) throws OseeCoreException {
        if (workItem.getStateMgr().getStateType().isCompletedOrCancelled()) {
            IAtsUser cancelledBy;
            IAtsUser completedBy;
            if (workItem.getStateMgr().getStateType().isCompleted() && (completedBy = workItem.getCompletedBy()) != null && !implementers.contains(completedBy)) {
                implementers.add(completedBy);
            }
            if (workItem.getStateMgr().getStateType().isCancelled() && (cancelledBy = workItem.getCancelledBy()) != null && !implementers.contains(cancelledBy)) {
                implementers.add(cancelledBy);
            }
        }
    }

    public void getImplementers_fromReviews(IAtsWorkItem workItem, List<IAtsUser> implementers) throws OseeCoreException {
        if (workItem.isDecisionReview()) {
            implementers.addAll(this.getImplementersByState(workItem, DecisionReviewState.Decision));
        } else {
            implementers.addAll(this.getImplementersByState(workItem, PeerToPeerReviewState.Review));
            IAtsPeerReviewRoleManager roleMgr = ((IAtsPeerToPeerReview)workItem).getRoleManager();
            List userRoles = roleMgr.getUserRoles();
            for (IAtsUser user : roleMgr.getRoleUsers((Collection)userRoles)) {
                implementers.add(user);
            }
        }
    }

    public List<IAtsUser> getActionGroupImplementers(IActionGroup actionGroup) throws OseeCoreException {
        LinkedList<IAtsUser> implementers = new LinkedList<IAtsUser>();
        for (IAtsWorkItem action : actionGroup.getActions()) {
            if (!action.getStateMgr().getStateType().isCompletedOrCancelled()) continue;
            for (IAtsUser user : this.getWorkItemImplementers(action)) {
                if (implementers.contains(user)) continue;
                implementers.add(user);
            }
        }
        return implementers;
    }

    public List<IAtsUser> getImplementersByState(IAtsWorkItem workflow, IStateToken state) throws OseeCoreException {
        ArrayList<IAtsUser> users = new ArrayList<IAtsUser>();
        if (workflow.isCancelled()) {
            users.add(workflow.getCancelledBy());
        } else {
            IAtsUser user2;
            for (IAtsUser user2 : workflow.getStateMgr().getAssignees(state.getName())) {
                if (users.contains(user2)) continue;
                users.add(user2);
            }
            if (workflow.isCompleted() && (user2 = workflow.getCompletedBy()) != null && !users.contains(user2)) {
                users.add(user2);
            }
        }
        return users;
    }
}

