/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsWorkItemFactory;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.agile.AgileBacklog;
import org.eclipse.osee.ats.core.agile.AgileItem;
import org.eclipse.osee.ats.core.agile.AgileSprint;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public abstract class AbstractWorkItemFactory
implements IAtsWorkItemFactory {
    protected final IAtsServices services;

    public AbstractWorkItemFactory(IAtsServices services) {
        this.services = services;
    }

    public Collection<IAtsWorkItem> getWorkItems(Collection<? extends ArtifactId> artifacts) {
        LinkedList<IAtsWorkItem> workItems = new LinkedList<IAtsWorkItem>();
        for (ArtifactId artifactId : artifacts) {
            IAtsWorkItem workItem = this.getWorkItem(artifactId);
            if (workItem == null) continue;
            workItems.add(workItem);
        }
        return workItems;
    }

    public IAtsWorkItem getWorkItem(ArtifactId artifact) {
        IAtsTeamWorkflow workItem = null;
        try {
            if (this.services.getStoreService().isOfType(artifact, new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                workItem = this.getTeamWf(artifact);
            } else if (this.services.getStoreService().isOfType(artifact, new ArtifactTypeId[]{AtsArtifactTypes.PeerToPeerReview}) || this.services.getStoreService().isOfType(artifact, new ArtifactTypeId[]{AtsArtifactTypes.DecisionReview})) {
                workItem = this.getReview(artifact);
            } else if (this.services.getStoreService().isOfType(artifact, new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
                workItem = this.getTask(artifact);
            } else if (this.services.getStoreService().isOfType(artifact, new ArtifactTypeId[]{AtsArtifactTypes.AgileBacklog})) {
                workItem = this.getAgileBacklog((ArtifactToken)artifact);
            } else if (this.services.getStoreService().isOfType(artifact, new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                workItem = this.getGoal(artifact);
            } else if (this.services.getStoreService().isOfType(artifact, new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
                workItem = this.getAgileSprint((ArtifactToken)artifact);
            }
        }
        catch (OseeCoreException ex) {
            this.services.getLogger().error((Throwable)ex, "Error getting work item for [%s]", new Object[]{artifact});
        }
        return workItem;
    }

    public IAgileSprint getAgileSprint(ArtifactToken artifact) throws OseeCoreException {
        Object sprint = null;
        sprint = artifact instanceof IAgileSprint ? (IAgileSprint)artifact : new AgileSprint(this.services.getLogger(), this.services, artifact);
        return sprint;
    }

    public IAgileBacklog getAgileBacklog(ArtifactToken artifact) throws OseeCoreException {
        Object backlog = null;
        backlog = artifact instanceof IAgileBacklog ? (IAgileBacklog)artifact : new AgileBacklog(this.services.getLogger(), this.services, artifact);
        return backlog;
    }

    public IAgileItem getAgileItem(ArtifactId artifact) {
        AgileItem item = null;
        ArtifactToken art = this.services.getArtifact(artifact);
        if (this.services.getStoreService().isOfType((ArtifactId)art, new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
            item = new AgileItem(this.services.getLogger(), this.services, art);
        }
        return item;
    }

    public IAtsWorkItem getWorkItemByAtsId(String atsId) {
        return (IAtsWorkItem)this.services.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAttr((AttributeTypeId)AtsAttributeTypes.AtsId, atsId, new QueryOption[0]).getResults().getOneOrNull();
    }
}

