/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.IWorkDefinitionMatch;
import org.eclipse.osee.ats.core.workdef.WorkDefinitionMatch;

public class AtsWorkDefinitionCache {
    private final Map<Long, IWorkDefinitionMatch> awaUuidToWorkDefinition = new ConcurrentHashMap<Long, IWorkDefinitionMatch>();
    private final Map<String, IWorkDefinitionMatch> workDefIdToWorkDefintion = new ConcurrentHashMap<String, IWorkDefinitionMatch>();

    public void cache(IAtsWorkDefinition workDef, WorkDefinitionMatch match) {
        this.cache(workDef.getName(), match);
    }

    public void cache(String id, WorkDefinitionMatch match) {
        this.workDefIdToWorkDefintion.put(id, match);
    }

    public void cache(IAtsWorkItem workItem, IWorkDefinitionMatch match) {
        this.awaUuidToWorkDefinition.put(workItem.getId(), match);
    }

    public void cache(String id, IAtsWorkDefinition workDef) {
        WorkDefinitionMatch match = new WorkDefinitionMatch(id, null);
        match.setWorkDefinition(workDef);
        this.workDefIdToWorkDefintion.put(id, match);
    }

    public IWorkDefinitionMatch getWorkDefinition(IAtsWorkItem workItem) {
        return this.awaUuidToWorkDefinition.get(workItem.getId());
    }

    public IWorkDefinitionMatch getWorkDefinition(String id) {
        return this.workDefIdToWorkDefintion.get(id);
    }

    public Iterable<IWorkDefinitionMatch> getAllWorkDefinitions() {
        return this.workDefIdToWorkDefintion.values();
    }

    public void invalidate(IAtsWorkDefinition workDef) {
        this.workDefIdToWorkDefintion.remove(workDef.getName());
    }

    public void invalidate() {
        this.awaUuidToWorkDefinition.clear();
        this.workDefIdToWorkDefintion.clear();
    }
}

