/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.ITeamWorkflowProvider;
import org.eclipse.osee.ats.api.workdef.IAtsRuleDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionAdmin;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.IWorkDefinitionMatch;
import org.eclipse.osee.ats.api.workdef.NullRuleDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.core.workdef.AtsWorkDefinitionCache;
import org.eclipse.osee.ats.core.workdef.WorkDefinitionMatch;
import org.eclipse.osee.ats.core.workflow.TeamWorkflowProviders;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.exception.MultipleAttributesExist;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsWorkDefinitionAdminImpl
implements IAtsWorkDefinitionAdmin {
    private final AtsWorkDefinitionCache workDefCache;
    private final IAtsWorkDefinitionService workDefinitionService;
    private final IAttributeResolver attributeResolver;
    private final ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy;
    private final Cache<String, IAtsRuleDefinition> ruleDefinitionCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public AtsWorkDefinitionAdminImpl(AtsWorkDefinitionCache workDefCache, IAtsWorkDefinitionService workDefinitionService, IAttributeResolver attributeResolver, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        this.workDefCache = workDefCache;
        this.workDefinitionService = workDefinitionService;
        this.attributeResolver = attributeResolver;
        this.teamWorkflowProvidersLazy = teamWorkflowProvidersLazy;
    }

    private AtsWorkDefinitionCache getCache() throws OseeCoreException {
        return this.workDefCache;
    }

    public void clearCaches() {
        this.workDefCache.invalidate();
    }

    public void addWorkDefinition(IAtsWorkDefinition workDef) throws OseeCoreException {
        WorkDefinitionMatch match = new WorkDefinitionMatch(workDef.getId(), "programatically added via " + this.getClass() + ".addWorkDefinition");
        match.setWorkDefinition(workDef);
        this.getCache().cache(workDef, match);
    }

    public void removeWorkDefinition(IAtsWorkDefinition workDef) throws OseeCoreException {
        this.getCache().invalidate(workDef);
    }

    public IWorkDefinitionMatch getWorkDefinition(IAtsWorkItem workItem) throws OseeCoreException {
        AtsWorkDefinitionCache cache = this.getCache();
        IWorkDefinitionMatch toReturn = cache.getWorkDefinition(workItem);
        if (toReturn == null) {
            toReturn = this.getWorkDefinitionNew(workItem);
            this.getCache().cache(workItem, toReturn);
        }
        return toReturn;
    }

    public IAtsRuleDefinition getRuleDefinition(final String name) {
        IAtsRuleDefinition ruleDef = null;
        try {
            ruleDef = (IAtsRuleDefinition)this.ruleDefinitionCache.get((Object)name, (Callable)new Callable<IAtsRuleDefinition>(){

                @Override
                public IAtsRuleDefinition call() {
                    List ruleDefinitions = AtsWorkDefinitionAdminImpl.this.workDefinitionService.getRuleDefinitions();
                    NullRuleDefinition ruleDefinition = NullRuleDefinition.getInstance();
                    for (IAtsRuleDefinition ruleDef : ruleDefinitions) {
                        if (!(ruleDef instanceof NullRuleDefinition)) {
                            AtsWorkDefinitionAdminImpl.this.ruleDefinitionCache.put((Object)ruleDef.getName(), (Object)ruleDef);
                        }
                        if (!ruleDef.getName().equals(name)) continue;
                        ruleDefinition = ruleDef;
                    }
                    return ruleDefinition;
                }
            });
        }
        catch (ExecutionException executionException) {
            OseeLog.logf(AtsWorkDefinitionAdminImpl.class, (Level)Level.WARNING, (String)"Could not load Rule Definition [%s]", (Object[])new Object[]{name});
        }
        return ruleDef;
    }

    public IWorkDefinitionMatch getWorkDefinition(String id) throws OseeCoreException {
        IWorkDefinitionMatch toReturn = this.getCache().getWorkDefinition(id);
        if (toReturn == null) {
            WorkDefinitionMatch match = new WorkDefinitionMatch();
            if (!match.isMatched()) {
                try {
                    XResultData resultData = new XResultData(false);
                    if (this.workDefinitionService == null) {
                        throw new IllegalStateException("ATS Work Definition Service is not found.");
                    }
                    IAtsWorkDefinition workDef = this.workDefinitionService.getWorkDef(id, resultData);
                    if (workDef != null) {
                        match.setWorkDefinition(workDef);
                        if (!resultData.isEmpty()) {
                            match.addTrace(String.format("from DSL provider loaded id [%s] [%s]", id, resultData.toString()));
                        } else {
                            match.addTrace(String.format("from DSL provider loaded id [%s]", id));
                        }
                    }
                }
                catch (Exception ex) {
                    return new WorkDefinitionMatch(null, ex.getLocalizedMessage());
                }
            }
            if (match.isMatched()) {
                OseeLog.logf(AtsWorkDefinitionAdminImpl.class, (Level)Level.FINE, (String)"Loaded Work Definition [%s]", (Object[])new Object[]{match});
                this.getCache().cache(id, match);
                toReturn = match;
            } else {
                OseeLog.logf(AtsWorkDefinitionAdminImpl.class, (Level)Level.SEVERE, (String)"Unable to load Work Definition [%s]", (Object[])new Object[]{id});
            }
        }
        if (toReturn == null) {
            toReturn = new WorkDefinitionMatch();
        }
        return toReturn;
    }

    private IWorkDefinitionMatch getWorkDefinitionFromArtifactsAttributeValue(IAtsTeamDefinition teamDef) throws OseeCoreException {
        IWorkDefinitionMatch match;
        String workFlowDefId = teamDef.getWorkflowDefinition();
        if (Strings.isValid((String)workFlowDefId) && (match = this.getWorkDefinition(workFlowDefId)).isMatched()) {
            match.addTrace(String.format("from artifact [%s] for id [%s]", teamDef, workFlowDefId));
            return match;
        }
        return new WorkDefinitionMatch();
    }

    private IWorkDefinitionMatch getTaskWorkDefinitionFromArtifactsAttributeValue(IAtsTeamDefinition teamDef) throws OseeCoreException {
        IWorkDefinitionMatch match;
        String workFlowDefId = teamDef.getRelatedTaskWorkDefinition();
        if (Strings.isValid((String)workFlowDefId) && (match = this.getWorkDefinition(workFlowDefId)).isMatched()) {
            match.addTrace(String.format("from artifact [%s] for id [%s]", teamDef, workFlowDefId));
            return match;
        }
        return new WorkDefinitionMatch();
    }

    private IWorkDefinitionMatch getWorkDefinitionFromArtifactsAttributeValue(IAtsWorkItem workItem) throws OseeCoreException {
        IWorkDefinitionMatch match;
        String workFlowDefId = null;
        Collection attributeValues = this.attributeResolver.getAttributeValues((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.WorkflowDefinition);
        if (!attributeValues.isEmpty()) {
            workFlowDefId = (String)attributeValues.iterator().next();
        }
        if (Strings.isValid(workFlowDefId) && (match = this.getWorkDefinition(workFlowDefId)).isMatched()) {
            match.addTrace(String.format("from artifact [%s] for id [%s]", workItem, workFlowDefId));
            return match;
        }
        return new WorkDefinitionMatch();
    }

    private IWorkDefinitionMatch getTaskWorkDefinitionFromArtifactsAttributeValue(IAtsWorkItem workItem) throws OseeCoreException {
        IWorkDefinitionMatch match;
        String workFlowDefId = null;
        Collection attributeValues = this.attributeResolver.getAttributeValues((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.RelatedTaskWorkDefinition);
        if (!attributeValues.isEmpty()) {
            workFlowDefId = (String)attributeValues.iterator().next();
        }
        if (Strings.isValid(workFlowDefId) && (match = this.getWorkDefinition(workFlowDefId)).isMatched()) {
            match.addTrace(String.format("from artifact [%s] for id [%s]", workItem, workFlowDefId));
            return match;
        }
        return new WorkDefinitionMatch();
    }

    private IWorkDefinitionMatch getWorkDefinitionFromTeamDefinitionAttributeInherited(IAtsTeamDefinition teamDef) throws OseeCoreException {
        IWorkDefinitionMatch match = this.getWorkDefinitionFromArtifactsAttributeValue(teamDef);
        if (match.isMatched()) {
            return match;
        }
        IAtsTeamDefinition parentArt = teamDef.getParentTeamDef();
        if (parentArt != null) {
            return this.getWorkDefinitionFromTeamDefinitionAttributeInherited(parentArt);
        }
        return new WorkDefinitionMatch();
    }

    public IWorkDefinitionMatch getWorkDefinitionForTask(IAtsTask task) throws OseeCoreException {
        IAtsTeamWorkflow teamWf = task.getParentTeamWorkflow();
        return this.getWorkDefinitionForTask(teamWf, task);
    }

    public IWorkDefinitionMatch getWorkDefinitionForTaskNotYetCreated(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        return this.getWorkDefinitionForTask(teamWf, null);
    }

    private IWorkDefinitionMatch getWorkDefinitionForTask(IAtsTeamWorkflow teamWf, IAtsTask task) throws OseeCoreException {
        WorkDefinitionMatch match;
        WorkDefinitionMatch workDefinitionMatch = match = task == null ? new WorkDefinitionMatch() : this.getWorkDefinitionFromArtifactsAttributeValue((IAtsWorkItem)task);
        if (teamWf != null) {
            IWorkDefinitionMatch match2;
            if (!match.isMatched() && task != null) {
                for (ITeamWorkflowProvider provider : TeamWorkflowProviders.getTeamWorkflowProviders()) {
                    String workFlowDefId = provider.getRelatedTaskWorkflowDefinitionId(teamWf);
                    this.attributeResolver.getSoleAttributeValue((ArtifactId)task.getStoreObject(), (AttributeTypeId)AtsAttributeTypes.WorkflowDefinition, null);
                    if (!Strings.isValid((String)workFlowDefId)) continue;
                    match = this.getWorkDefinition(workFlowDefId);
                    match.addTrace(String.format("from provider [%s] for id [%s]", provider.getClass().getSimpleName(), workFlowDefId));
                    break;
                }
            }
            if (!match.isMatched() && (match2 = this.getTaskWorkDefinitionFromArtifactsAttributeValue((IAtsWorkItem)teamWf)).isMatched()) {
                match2.addTrace(String.format("from task parent SMA [%s]", teamWf));
                match = match2;
            }
            if (!match.isMatched()) {
                match = this.getTaskWorkDefinitionFromArtifactsAttributeValue(teamWf.getTeamDefinition());
            }
        }
        if (!match.isMatched()) {
            match = this.getWorkDefinition("WorkDef_Task_Default");
            match.addTrace("WorkDefinitionFactory - Default Task");
        }
        return match;
    }

    private IWorkDefinitionMatch getWorkDefinitionNew(IAtsWorkItem workItem) throws OseeCoreException {
        WorkDefinitionMatch match = new WorkDefinitionMatch();
        if (workItem instanceof IAtsTask) {
            match = this.getWorkDefinitionForTask((IAtsTask)workItem);
        }
        if (!match.isMatched()) {
            for (ITeamWorkflowProvider provider : this.teamWorkflowProvidersLazy.getProviders()) {
                String workFlowDefId = provider.getWorkflowDefinitionId(workItem);
                if (!Strings.isValid((String)workFlowDefId)) continue;
                match = this.getWorkDefinition(workFlowDefId);
            }
            if (!match.isMatched() && !(match = this.getWorkDefinitionFromArtifactsAttributeValue(workItem)).isMatched()) {
                if (workItem instanceof IAtsTeamWorkflow) {
                    IAtsTeamDefinition teamDef = ((IAtsTeamWorkflow)workItem).getTeamDefinition();
                    match = this.getWorkDefinitionFromTeamDefinitionAttributeInherited(teamDef);
                } else if (workItem instanceof IAtsGoal) {
                    match = this.getWorkDefinition("WorkDef_Goal");
                    match.addTrace("WorkDefinitionFactory - GoalWorkflowDefinitionId");
                } else if (workItem instanceof IAgileBacklog) {
                    match = this.getWorkDefinition("WorkDef_Goal");
                    match.addTrace("WorkDefinitionFactory - GoalWorkflowDefinitionId");
                } else if (workItem instanceof IAgileSprint) {
                    match = this.getWorkDefinition("WorkDef_Sprint");
                    match.addTrace("WorkDefinitionFactory - SprintWorkflowDefinitionId");
                } else if (workItem instanceof IAtsPeerToPeerReview) {
                    match = this.getWorkDefinition("WorkDef_Review_PeerToPeer");
                    match.addTrace("WorkDefinitionFactory - PeerToPeerWorkflowDefinitionId");
                } else if (workItem instanceof IAtsDecisionReview) {
                    match = this.getWorkDefinition("WorkDef_Review_Decision");
                    match.addTrace("WorkDefinitionFactory - DecisionWorkflowDefinitionId");
                }
            }
        }
        return match;
    }

    public boolean isTaskOverridingItsWorkDefinition(IAtsTask task) throws MultipleAttributesExist, OseeCoreException {
        return this.attributeResolver.getSoleAttributeValueAsString((IAtsObject)task, (AttributeTypeId)AtsAttributeTypes.WorkflowDefinition, null) != null;
    }

    public IWorkDefinitionMatch getWorkDefinitionForPeerToPeerReview(IAtsPeerToPeerReview review) throws OseeCoreException {
        Conditions.notNull((Object[])new Object[]{review, AtsWorkDefinitionAdminImpl.class.getSimpleName()});
        IWorkDefinitionMatch match = this.getWorkDefinitionFromArtifactsAttributeValue((IAtsWorkItem)review);
        if (!match.isMatched()) {
            match = this.getDefaultPeerToPeerWorkflowDefinitionMatch();
        }
        return match;
    }

    public IWorkDefinitionMatch getDefaultPeerToPeerWorkflowDefinitionMatch() throws OseeCoreException {
        IWorkDefinitionMatch match = this.getWorkDefinition("WorkDef_Review_PeerToPeer");
        match.addTrace("WorkDefinitionFactory - Default PeerToPeer");
        return match;
    }

    public IWorkDefinitionMatch getWorkDefinitionForPeerToPeerReviewNotYetCreated(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        Conditions.notNull((Object[])new Object[]{teamWf, AtsWorkDefinitionAdminImpl.class.getSimpleName()});
        IAtsTeamDefinition teamDefinition = teamWf.getTeamDefinition();
        IWorkDefinitionMatch match = this.getPeerToPeerWorkDefinitionFromTeamDefinitionAttributeValueRecurse(teamDefinition);
        if (!match.isMatched()) {
            match = this.getDefaultPeerToPeerWorkflowDefinitionMatch();
        }
        return match;
    }

    public IWorkDefinitionMatch getWorkDefinitionForPeerToPeerReviewNotYetCreatedAndStandalone(IAtsActionableItem actionableItem) throws OseeCoreException {
        Conditions.notNull((Object[])new Object[]{actionableItem, AtsWorkDefinitionAdminImpl.class.getSimpleName()});
        IWorkDefinitionMatch match = this.getPeerToPeerWorkDefinitionFromTeamDefinitionAttributeValueRecurse(actionableItem.getTeamDefinitionInherited());
        if (!match.isMatched()) {
            match = this.getDefaultPeerToPeerWorkflowDefinitionMatch();
        }
        return match;
    }

    public IWorkDefinitionMatch getPeerToPeerWorkDefinitionFromTeamDefinitionAttributeValueRecurse(IAtsTeamDefinition teamDefinition) throws OseeCoreException {
        Conditions.notNull((Object[])new Object[]{teamDefinition, AtsWorkDefinitionAdminImpl.class.getSimpleName()});
        WorkDefinitionMatch match = new WorkDefinitionMatch();
        String workDefId = teamDefinition.getRelatedPeerWorkDefinition();
        if (!Strings.isValid((String)workDefId)) {
            IAtsTeamDefinition parentTeamDef = teamDefinition.getParentTeamDef();
            if (parentTeamDef != null) {
                match = this.getPeerToPeerWorkDefinitionFromTeamDefinitionAttributeValueRecurse(parentTeamDef);
            }
        } else {
            match = this.getWorkDefinition(workDefId);
            match.addTrace("PeerToPeer from Team Definition");
        }
        return match;
    }

    public IAtsWorkDefinition copyWorkDefinition(String newName, IAtsWorkDefinition workDef, XResultData resultData) {
        return this.workDefinitionService.copyWorkDefinition(newName, workDef, resultData);
    }

    public List<IAtsStateDefinition> getStatesOrderedByOrdinal(IAtsWorkDefinition workDef) {
        return this.workDefinitionService.getStatesOrderedByOrdinal(workDef);
    }

    public Collection<String> getStateNames(IAtsWorkDefinition workDef) {
        return this.workDefinitionService.getStateNames(workDef);
    }

    public String getStorageString(IAtsWorkDefinition workDef, XResultData resultData) throws Exception {
        return this.workDefinitionService.getStorageString(workDef, resultData);
    }

    public IAtsWorkDefinition getWorkDef(String id, XResultData resultData) throws Exception {
        return this.workDefinitionService.getWorkDef(id, resultData);
    }

    public List<IAtsWidgetDefinition> getWidgetsFromLayoutItems(IAtsStateDefinition stateDef) {
        return this.workDefinitionService.getWidgetsFromLayoutItems(stateDef);
    }

    public boolean isStateWeightingEnabled(IAtsWorkDefinition workDef) {
        return this.workDefinitionService.isStateWeightingEnabled(workDef);
    }

    public IAtsStateDefinition getStateDefinitionByName(IAtsWorkItem workItem, String stateName) throws OseeCoreException {
        return this.getWorkDefinition(workItem).getWorkDefinition().getStateByName(stateName);
    }

    public Collection<String> getAllValidStateNames(XResultData resultData) throws Exception {
        return this.workDefinitionService.getAllValidStateNames(resultData);
    }

    public void clearRuleDefinitionsCache() {
        this.ruleDefinitionCache.invalidateAll();
    }

    public Collection<IAtsRuleDefinition> getAllRuleDefinitions() {
        if (this.ruleDefinitionCache.size() == 0L) {
            List ruleDefinitions = this.workDefinitionService.getRuleDefinitions();
            for (IAtsRuleDefinition ruleDef : ruleDefinitions) {
                this.ruleDefinitionCache.put((Object)ruleDef.getName(), (Object)ruleDef);
            }
        }
        Collection<IAtsRuleDefinition> ruleDefs = this.ruleDefinitionCache.asMap().values();
        return ruleDefs;
    }
}

