/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.version;

import java.rmi.activation.Activator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.IAtsVersionService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.Identity;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class AtsVersionServiceImpl
implements IAtsVersionService {
    private final IAtsServices services;
    private final EventAdmin eventAdmin;

    public AtsVersionServiceImpl(IAtsServices services, EventAdmin eventAdmin) {
        this.services = services;
        this.eventAdmin = eventAdmin;
    }

    public IAtsVersion getTargetedVersion(IAtsWorkItem workItem) throws OseeCoreException {
        IAtsVersion version = null;
        IAtsTeamWorkflow team = workItem.getParentTeamWorkflow();
        if (team != null) {
            version = this.getTargetedVersionByTeamWf(team);
        }
        return version;
    }

    public IAtsVersion getTargetedVersionByTeamWf(IAtsTeamWorkflow team) throws OseeCoreException {
        if (team == null) {
            throw new OseeArgumentException("Team Workflow can not be null %s", new Object[]{team});
        }
        Collection versions = this.services.getRelationResolver().getRelated((ArtifactId)team.getStoreObject(), AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
        IAtsVersion version = null;
        if (!versions.isEmpty()) {
            if (versions.size() > 1) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)("Multiple targeted versions for artifact " + team.toStringWithId()));
            } else {
                version = this.services.getConfigItemFactory().getVersion((ArtifactId)versions.iterator().next());
            }
        }
        return version;
    }

    public void removeTargetedVersion(IAtsTeamWorkflow teamWf, IAtsChangeSet changes) throws OseeCoreException {
        changes.unrelateAll((Object)teamWf, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
    }

    public IAtsVersion setTargetedVersion(IAtsTeamWorkflow teamWf, IAtsVersion version, IAtsChangeSet changes) {
        Collection previousVersions = this.services.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
        ArtifactId previousVersion = ArtifactId.SENTINEL;
        if (!previousVersions.isEmpty()) {
            previousVersion = ArtifactId.valueOf((long)((ArtifactToken)previousVersions.iterator().next()).getId());
        }
        changes.setRelation((Object)teamWf, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version, (Object)version);
        changes.addExecuteListener(this.getPostPersistExecutionListener(teamWf, version, previousVersion));
        return version;
    }

    protected IExecuteListener getPostPersistExecutionListener(final IAtsTeamWorkflow teamWf, final IAtsVersion newVersion, final ArtifactId previousVersion) {
        return new IExecuteListener(){

            public void changesStored(IAtsChangeSet changes) {
                try {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("workItemUuids", teamWf.getIdString());
                    properties.put("atsVersionId", newVersion.getIdString());
                    properties.put("previousAtsVersionId", previousVersion.getIdString());
                    Event event = new Event("ats/workitem/targetedversion/modified", properties);
                    AtsVersionServiceImpl.this.eventAdmin.postEvent(event);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(this.getClass(), (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        };
    }

    public boolean isReleased(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        boolean released = false;
        IAtsVersion verArt = this.getTargetedVersion((IAtsWorkItem)teamWf);
        if (verArt != null) {
            released = verArt.isReleased();
        }
        return released;
    }

    public boolean isVersionLocked(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        boolean locked = false;
        IAtsVersion verArt = this.getTargetedVersion((IAtsWorkItem)teamWf);
        if (verArt != null) {
            locked = verArt.isVersionLocked();
        }
        return locked;
    }

    public boolean hasTargetedVersion(IAtsWorkItem workItem) throws OseeCoreException {
        return this.getTargetedVersion(workItem) != null;
    }

    public void setTeamDefinition(IAtsVersion version, IAtsTeamDefinition teamDef, IAtsChangeSet changes) throws OseeCoreException {
        ArtifactToken verArt = this.services.getArtifact((IAtsObject)version);
        if (verArt == null) {
            throw new OseeStateException("Version [%s] does not exist.", new Object[]{version});
        }
        ArtifactToken teamDefArt = this.services.getArtifact((IAtsObject)teamDef);
        if (teamDefArt == null) {
            throw new OseeStateException("Team Definition [%s] does not exist.", new Object[]{teamDef});
        }
        if (!this.services.getRelationResolver().areRelated((IAtsObject)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition, (IAtsObject)teamDef)) {
            changes.relate((Object)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition, (Object)teamDefArt);
        }
    }

    public IAtsTeamDefinition getTeamDefinition(IAtsVersion version) throws OseeCoreException {
        return (IAtsTeamDefinition)this.services.getRelationResolver().getRelatedOrNull((IAtsObject)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition, IAtsTeamDefinition.class);
    }

    public IAtsVersion getById(Identity<String> id) throws OseeCoreException {
        IAtsVersion version = null;
        ArtifactToken verArt = null;
        verArt = id instanceof ArtifactId ? this.services.getArtifact(((ArtifactId)id).getUuid()) : this.services.getArtifactById((String)id.getGuid());
        if (verArt != null) {
            version = this.services.getConfigItemFactory().getVersion((ArtifactId)verArt);
        }
        return version;
    }

    public Collection<IAtsTeamWorkflow> getTargetedForTeamWorkflows(IAtsVersion verArt) throws OseeCoreException {
        LinkedList<IAtsTeamWorkflow> teamWorkflows = new LinkedList<IAtsTeamWorkflow>();
        for (IAtsTeamWorkflow teamWf : this.services.getRelationResolver().getRelated((IAtsObject)verArt, AtsRelationTypes.TeamWorkflowTargetedForVersion_Workflow, IAtsTeamWorkflow.class)) {
            teamWorkflows.add(teamWf);
        }
        return teamWorkflows;
    }

    public BranchId getBranch(IAtsVersion version) {
        String branchId = (String)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)version, (AttributeTypeId)AtsAttributeTypes.BaselineBranchUuid, (Object)"");
        if (branchId == null || branchId.isEmpty()) {
            return BranchId.SENTINEL;
        }
        return BranchId.valueOf((String)branchId);
    }

    public IAtsVersion createVersion(IAtsProgram program, String versionName, IAtsChangeSet changes) {
        IAtsVersion version = null;
        version = this.services.getProgramService().getVersion(program, versionName);
        if (version == null) {
            version = this.services.getConfigItemFactory().getVersion(changes.createArtifact(AtsArtifactTypes.Version, versionName));
        }
        return version;
    }

    public IAtsVersion getVersion(IAtsProgram program, String versionName, IAtsChangeSet changes) {
        return this.services.getProgramService().getVersion(program, versionName);
    }

    public IAtsVersion createVersion(String title, String guid, long uuid, IAtsChangeSet changes) throws OseeCoreException {
        return this.services.getVersionFactory().createVersion(title, guid, uuid, changes, this.services);
    }

    public IAtsVersion createVersion(String name, IAtsChangeSet changes) throws OseeCoreException {
        return this.services.getVersionFactory().createVersion(name, changes, this.services);
    }

    public Collection<IAtsVersion> getVersions(IAtsTeamDefinition teamDef) {
        return this.services.getTeamDefinitionService().getVersions(teamDef);
    }
}

