/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.validator;

import java.util.Date;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.api.workdef.WidgetOption;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.WidgetStatus;
import org.eclipse.osee.ats.api.workflow.transition.IAtsXWidgetValidator;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public abstract class AtsXWidgetValidator
implements IAtsXWidgetValidator {
    public boolean isTransitionToComplete(IAtsStateDefinition toStateDef) {
        return toStateDef.getStateType().isCompletedState();
    }

    public boolean isRequiredForTransition(IAtsWidgetDefinition widgetDef) {
        return widgetDef.getOptions().contains(WidgetOption.REQUIRED_FOR_TRANSITION);
    }

    public boolean isRequiredForCompletion(IAtsWidgetDefinition widgetDef) {
        return widgetDef.getOptions().contains(WidgetOption.REQUIRED_FOR_COMPLETION);
    }

    public boolean isEmptyValue(IValueProvider provider) throws OseeCoreException {
        return provider.isEmpty();
    }

    public WidgetResult validateWidgetIsRequired(IValueProvider provider, IAtsWidgetDefinition widgetDef, IAtsStateDefinition fromStateDef, IAtsStateDefinition toStateDef) throws OseeCoreException {
        if (this.isRequiredForTransition(widgetDef) && this.isEmptyValue(provider)) {
            return new WidgetResult(WidgetStatus.Invalid_Incompleted, widgetDef, "[%s] is required for transition", new Object[]{widgetDef.getName()});
        }
        if (this.isTransitionToComplete(toStateDef) && this.isRequiredForCompletion(widgetDef) && this.isEmptyValue(provider)) {
            return new WidgetResult(WidgetStatus.Invalid_Incompleted, widgetDef, "[%s] is required for transition to [%s]", new Object[]{widgetDef.getName(), toStateDef.getName()});
        }
        return WidgetResult.Valid;
    }

    public abstract WidgetResult validateTransition(IAtsWorkItem var1, IValueProvider var2, IAtsWidgetDefinition var3, IAtsStateDefinition var4, IAtsStateDefinition var5, IAtsServices var6) throws OseeCoreException;

    public WidgetResult isValidDate(IValueProvider valueProvider, IAtsWidgetDefinition widgetDef) throws OseeCoreException {
        for (Date date : valueProvider.getDateValues()) {
            if (!widgetDef.is(WidgetOption.FUTURE_DATE_REQUIRED) || !date.before(new Date())) continue;
            return new WidgetResult(WidgetStatus.Invalid_Range, widgetDef, "[%s] value [%s] must be in future", new Object[]{valueProvider.getName(), DateUtil.get((Date)date, (String)"MM/dd/yyyy hh:mm a")});
        }
        return WidgetResult.Valid;
    }

    public WidgetResult isValid(IValueProvider valueProvider, IAtsWidgetDefinition widgetDef) {
        for (String attrStr : valueProvider.getValues()) {
            if (attrStr.matches("[-+]?\\d*\\.?\\d*")) {
                WidgetResult result = this.checkValid(widgetDef, Double.parseDouble(attrStr), valueProvider.getName());
                if (result.isValid()) continue;
                return result;
            }
            return new WidgetResult(WidgetStatus.Invalid_Type, widgetDef, "[%s] value [%s] is not a valid number", new Object[]{valueProvider.getName(), attrStr});
        }
        return WidgetResult.Valid;
    }

    private WidgetResult checkValid(IAtsWidgetDefinition widgetDef, double value, String valueProviderName) {
        Double minValue = widgetDef.getMin();
        Double maxValue = widgetDef.getMax();
        if (minValue != null && Lib.lessThan((double)value, (double)minValue)) {
            return new WidgetResult(WidgetStatus.Invalid_Range, widgetDef, "[%s] value [%s] must be >= [%s]", new Object[]{valueProviderName, value, minValue});
        }
        if (maxValue != null && Lib.greaterThan((double)value, (double)maxValue)) {
            return new WidgetResult(WidgetStatus.Invalid_Range, widgetDef, "[%s] value [%s] must be <= [%s]", new Object[]{valueProviderName, value, minValue, maxValue});
        }
        return WidgetResult.Valid;
    }

    public WidgetResult isValidList(IValueProvider valueProvider, IAtsWidgetDefinition widgetDef) throws OseeCoreException {
        return this.checkValid(widgetDef, valueProvider.getValues().size(), valueProvider.getName());
    }
}

