/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.WidgetStatus;
import org.eclipse.osee.ats.api.workflow.transition.IAtsXWidgetValidator;
import org.eclipse.osee.ats.api.workflow.transition.IAtsXWidgetValidatorProvider;
import org.eclipse.osee.ats.core.util.ArtifactValueProvider;
import org.eclipse.osee.ats.core.validator.AtsCoreXWidgetValidatorProvider;

public class AtsXWidgetValidateManager {
    private static List<IAtsXWidgetValidatorProvider> providers;

    public void addWidgetValidatorProvider(IAtsXWidgetValidatorProvider provider) {
        AtsXWidgetValidateManager.getProviders().add(provider);
    }

    public void removeWidgetValidatorProvider(IAtsXWidgetValidatorProvider provider) {
        AtsXWidgetValidateManager.getProviders().remove(provider);
    }

    public static List<WidgetResult> validateTransition(IAtsWorkItem workItem, List<WidgetResult> results, IValueProvider valueProvider, IAtsWidgetDefinition widgetDef, IAtsStateDefinition fromStateDef, IAtsStateDefinition toStateDef, IAtsServices atsServices) {
        for (IAtsXWidgetValidatorProvider provider : AtsXWidgetValidateManager.getProviders()) {
            for (IAtsXWidgetValidator validator : provider.getValidators()) {
                try {
                    WidgetResult status = validator.validateTransition(workItem, valueProvider, widgetDef, fromStateDef, toStateDef, atsServices);
                    if (status.isValid()) continue;
                    results.add(status);
                }
                catch (Exception ex) {
                    results.add(new WidgetResult(WidgetStatus.Exception, widgetDef, ex, String.format("Exception retriving validation for widget [%s] Exception [%s]", validator.getClass().getSimpleName(), ex.getLocalizedMessage()), new Object[]{ex}));
                }
            }
        }
        return results;
    }

    static List<IAtsXWidgetValidatorProvider> getProviders() {
        if (providers == null) {
            providers = new LinkedList<IAtsXWidgetValidatorProvider>();
            providers.add(new AtsCoreXWidgetValidatorProvider());
        }
        return providers;
    }

    public static Collection<WidgetResult> validateTransition(IAtsWorkItem workItem, IAtsStateDefinition toStateDef, IAtsServices services) {
        ArrayList<WidgetResult> results = new ArrayList<WidgetResult>();
        for (IAtsWidgetDefinition widgetDef : services.getWorkDefinitionAdmin().getWidgetsFromLayoutItems(workItem.getStateDefinition())) {
            ArtifactValueProvider provider = new ArtifactValueProvider(workItem.getStoreObject(), widgetDef, services);
            AtsXWidgetValidateManager.validateTransition(workItem, results, provider, widgetDef, workItem.getStateDefinition(), toStateDef, services);
        }
        return results;
    }
}

