/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class PercentCompleteTotalUtil {
    public static int getPercentCompleteTotal(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        int percent = 0;
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            if (workItem.getStateMgr().getStateType().isCompletedOrCancelled()) {
                percent = 100;
            } else if (services.getWorkDefService().isStateWeightingEnabled(workItem.getWorkDefinition())) {
                for (IAtsStateDefinition stateDef : workItem.getWorkDefinition().getStates()) {
                    if (stateDef.getStateType().isCompletedState() || stateDef.getStateType().isCancelledState()) continue;
                    percent = PercentCompleteTotalUtil.addStatePercentWithWeight(services, percent, workItem, stateDef);
                }
            } else {
                percent = PercentCompleteTotalUtil.getPercentCompleteSMASinglePercent((IAtsObject)workItem, services);
                if (percent == 0 && PercentCompleteTotalUtil.isAnyStateHavePercentEntered(workItem)) {
                    int numStates = 0;
                    for (IAtsStateDefinition state : workItem.getWorkDefinition().getStates()) {
                        if (state.getStateType().isCompletedState() || state.getStateType().isCancelledState()) continue;
                        percent += PercentCompleteTotalUtil.getPercentCompleteSMAStateTotal((IAtsObject)workItem, (IStateToken)state, services);
                        ++numStates;
                    }
                    if (numStates > 0) {
                        percent /= numStates;
                    }
                }
            }
        }
        return percent;
    }

    private static int addStatePercentWithWeight(IAtsServices services, int percent, IAtsWorkItem workItem, IAtsStateDefinition stateDef) {
        double stateWeightInt = stateDef.getStateWeight();
        double weight = stateWeightInt / 100.0;
        int percentCompleteForState = PercentCompleteTotalUtil.getPercentCompleteSMAStateTotal((IAtsObject)workItem, (IStateToken)stateDef, services);
        percent = (int)((double)percent + weight * (double)percentCompleteForState);
        return percent;
    }

    private static boolean isAnyStateHavePercentEntered(IAtsWorkItem workItem) throws OseeCoreException {
        for (String stateName : workItem.getStateMgr().getVisitedStateNames()) {
            if (workItem.getStateMgr().getPercentComplete(stateName) == 0) continue;
            return true;
        }
        return false;
    }

    private static int getPercentCompleteSMASinglePercent(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        int percent = 0;
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            int numObjects = 1;
            percent = (Integer)services.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.PercentComplete, (Object)0);
            if (workItem instanceof IAtsTeamWorkflow) {
                for (IAtsAbstractReview revArt : services.getWorkItemService().getReviews((IAtsTeamWorkflow)workItem)) {
                    percent += PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)revArt, services);
                    ++numObjects;
                }
            }
            if (workItem instanceof IAtsTeamWorkflow) {
                for (IAtsTask taskArt : services.getTaskService().getTasks((IAtsTeamWorkflow)workItem)) {
                    percent += PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)taskArt, services);
                    ++numObjects;
                }
            }
            if (percent > 0 && numObjects > 0) {
                percent /= numObjects;
            }
        }
        return percent;
    }

    public static int getPercentCompleteSMAStateTotal(IAtsObject atsObject, IStateToken state, IAtsServices services) throws OseeCoreException {
        return PercentCompleteTotalUtil.getStateMetricsData(atsObject, state, services).getResultingPercent();
    }

    private static StateMetricsData getStateMetricsData(IAtsObject atsObject, IStateToken teamState, IAtsServices services) throws OseeCoreException {
        if (!(atsObject instanceof IAtsWorkItem)) {
            return null;
        }
        IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
        int percent = PercentCompleteTotalUtil.getPercentCompleteSMAState((IAtsObject)workItem, teamState);
        int numObjects = 1;
        if (workItem instanceof IAtsTeamWorkflow) {
            Collection tasks = services.getTaskService().getTasks((IAtsTeamWorkflow)workItem, teamState);
            for (IAtsTask taskArt : tasks) {
                percent += PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)taskArt, services);
            }
            numObjects += tasks.size();
        }
        if (workItem instanceof IAtsTeamWorkflow) {
            Collection reviews = services.getWorkItemService().getReviews((IAtsTeamWorkflow)workItem, teamState);
            for (IAtsAbstractReview reviewArt : reviews) {
                percent += PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)reviewArt, services);
            }
            numObjects += reviews.size();
        }
        return new StateMetricsData(percent, numObjects);
    }

    public static int getPercentCompleteSMAState(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        int percent = 0;
        if (atsObject instanceof IAtsAction) {
            IAtsAction action = (IAtsAction)atsObject;
            if (((IAtsAction)atsObject).getTeamWorkflows().size() == 1) {
                return PercentCompleteTotalUtil.getPercentCompleteSMAState((IAtsObject)services.getWorkItemService().getFirstTeam((Object)action), services);
            }
            int items = 0;
            for (IAtsTeamWorkflow team : ((IAtsAction)atsObject).getTeamWorkflows()) {
                if (team.getStateMgr().getStateType().isCancelled()) continue;
                percent += PercentCompleteTotalUtil.getPercentCompleteSMAState((IAtsObject)team, services);
                ++items;
            }
            if (items > 0) {
                Double rollPercent = new Double(percent) / (double)items;
                percent = rollPercent.intValue();
            }
        } else if (atsObject instanceof IAtsWorkItem) {
            return PercentCompleteTotalUtil.getPercentCompleteSMAState(atsObject, services.getWorkItemService().getCurrentState((IAtsWorkItem)atsObject));
        }
        return percent;
    }

    public static int getPercentCompleteSMAState(IAtsObject atsObject, IStateToken state) throws OseeCoreException {
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            return workItem.getStateMgr().getPercentComplete(state.getName());
        }
        return 0;
    }

    private static class StateMetricsData {
        public int numObjects = 0;
        public int percent = 0;

        public StateMetricsData(int percent, int numObjects) {
            this.numObjects = numObjects;
            this.percent = percent;
        }

        public int getResultingPercent() {
            return this.percent / this.numObjects;
        }

        public String toString() {
            return "Percent: " + this.getResultingPercent() + "  NumObjs: " + this.numObjects + "  Total Percent: " + this.percent;
        }
    }
}

