/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.workflow.state.SimpleTeamState;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class HoursSpentUtil {
    public static double getHoursSpentTotal(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsAction) {
            for (IAtsTeamWorkflow team : ((IAtsAction)atsObject).getTeamWorkflows()) {
                if (team.getStateMgr().getStateType().isCancelled()) continue;
                hours += HoursSpentUtil.getHoursSpentTotal((IAtsObject)team, services);
            }
        } else if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            hours = HoursSpentUtil.getHoursSpentTotal((IAtsObject)workItem, services.getWorkItemService().getCurrentState(workItem), services);
        }
        return hours;
    }

    public static double getHoursSpentTotal(IAtsObject atsObject, IStateToken state, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            hours = HoursSpentUtil.getHoursSpentTotalSMAState(hours, workItem) + HoursSpentUtil.getHoursSpentFromTasks(atsObject, services) + HoursSpentUtil.getHoursSpentReview(atsObject, services);
        }
        return hours;
    }

    public static double getHoursSpentTotalSMAState(double hours, IAtsWorkItem workItem) {
        for (String stateName : workItem.getStateMgr().getVisitedStateNames()) {
            SimpleTeamState teamState = new SimpleTeamState(stateName, StateType.Working);
            hours += HoursSpentUtil.getHoursSpentSMAState((IAtsObject)workItem, teamState);
        }
        return hours;
    }

    public static double getHoursSpentStateTotal(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsAction) {
            for (IAtsTeamWorkflow team : ((IAtsAction)atsObject).getTeamWorkflows()) {
                if (team.getStateMgr().getStateType().isCancelled()) continue;
                hours += HoursSpentUtil.getHoursSpentStateTotal((IAtsObject)team, services);
            }
        } else if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            hours = HoursSpentUtil.getHoursSpentStateTotal((IAtsObject)workItem, services.getWorkItemService().getCurrentState(workItem), services);
        }
        return hours;
    }

    public static double getHoursSpentStateTotal(IAtsObject atsObject, IStateToken state, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            hours = HoursSpentUtil.getHoursSpentSMAState((IAtsObject)workItem, state) + HoursSpentUtil.getHoursSpentFromStateTasks((IAtsObject)workItem, state, services) + HoursSpentUtil.getHoursSpentStateReview((IAtsObject)workItem, state, services);
        }
        return hours;
    }

    public static double getHoursSpentStateReview(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsAction) {
            for (IAtsTeamWorkflow team : ((IAtsAction)atsObject).getTeamWorkflows()) {
                if (team.getStateMgr().getStateType().isCancelled()) continue;
                hours += HoursSpentUtil.getHoursSpentStateReview((IAtsObject)team, services);
            }
        } else if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            hours = HoursSpentUtil.getHoursSpentStateReview((IAtsObject)workItem, services.getWorkItemService().getCurrentState(workItem), services);
        }
        return hours;
    }

    public static double getHoursSpentStateReview(IAtsObject atsObject, IStateToken state, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsTeamWorkflow) {
            for (IAtsAbstractReview review : services.getWorkItemService().getReviews((IAtsTeamWorkflow)atsObject, state)) {
                hours += review.getStateMgr().getHoursSpent(state.getName());
            }
        }
        return hours;
    }

    public static double getHoursSpentReview(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsTeamWorkflow) {
            for (IAtsAbstractReview review : services.getWorkItemService().getReviews((IAtsTeamWorkflow)atsObject)) {
                hours += HoursSpentUtil.getHoursSpentTotal((IAtsObject)review, services);
            }
        }
        return hours;
    }

    public static double getHoursSpentSMAState(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsAction) {
            for (IAtsTeamWorkflow team : ((IAtsAction)atsObject).getTeamWorkflows()) {
                if (team.getStateMgr().getStateType().isCancelled()) continue;
                hours += HoursSpentUtil.getHoursSpentSMAState((IAtsObject)team, services);
            }
        } else if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            hours = HoursSpentUtil.getHoursSpentSMAState((IAtsObject)workItem, services.getWorkItemService().getCurrentState(workItem));
        }
        return hours;
    }

    public static double getHoursSpentSMAState(IAtsObject atsObject, IStateToken state) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            hours = workItem.getStateMgr().getHoursSpent(state.getName());
        }
        return hours;
    }

    public static double getHoursSpentFromStateTasks(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsAction) {
            for (IAtsTeamWorkflow team : ((IAtsAction)atsObject).getTeamWorkflows()) {
                if (team.getStateMgr().getStateType().isCancelled()) continue;
                hours += HoursSpentUtil.getHoursSpentFromStateTasks((IAtsObject)team, services);
            }
        } else if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            hours = HoursSpentUtil.getHoursSpentFromStateTasks((IAtsObject)workItem, services.getWorkItemService().getCurrentState(workItem), services);
        }
        return hours;
    }

    public static double getHoursSpentFromStateTasks(IAtsObject atsObject, IStateToken relatedToState, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsTeamWorkflow) {
            for (IAtsTask taskArt : services.getTaskService().getTasks((IAtsTeamWorkflow)atsObject, relatedToState)) {
                hours += HoursSpentUtil.getHoursSpentTotal((IAtsObject)taskArt, services);
            }
        }
        return hours;
    }

    public static double getHoursSpentFromTasks(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        double hours = 0.0;
        if (atsObject instanceof IAtsTeamWorkflow) {
            for (IAtsTask taskArt : services.getTaskService().getTasks((IAtsTeamWorkflow)atsObject)) {
                hours += HoursSpentUtil.getHoursSpentTotal((IAtsObject)taskArt, services);
            }
        }
        return hours;
    }
}

