/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAttribute;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ConvertAtsConfigGuidAttributesOperations {
    public static final AttributeTypeToken TeamDefinition = AtsAttributeTypes.createType((Long)0x10000000000000E1L, (String)"Team Definition");
    public static final AttributeTypeToken ActionableItem = AtsAttributeTypes.createType((Long)0x10000000000000E0L, (String)"Actionable Item", (String)"Actionable Items that are impacted by this change.");

    public static void convertActionableItemsIfNeeded(IAtsChangeSet changes, ArtifactToken art, IAtsServices services) {
        Collection currentAiRefIds = services.getAttributeResolver().getAttributeValues((ArtifactId)art, (AttributeTypeId)AtsAttributeTypes.ActionableItemReference);
        LinkedList<ArtifactToken> neededAiRefIds = new LinkedList<ArtifactToken>();
        for (IAttribute iAttribute : services.getAttributeResolver().getAttributes((ArtifactId)art, (AttributeTypeId)ActionableItem)) {
            String aiArtGuid = (String)iAttribute.getValue();
            IAtsActionableItem ai = (IAtsActionableItem)services.getConfigItem(aiArtGuid);
            if (ai == null) {
                services.getLogger().error("AI not found for aiArtGuid " + aiArtGuid + " for art " + art.toStringWithId(), new Object[0]);
                continue;
            }
            if (currentAiRefIds.contains(ai.getId())) continue;
            neededAiRefIds.add(ai.getStoreObject());
        }
        for (ArtifactId artifactId : neededAiRefIds) {
            changes.addArtifactReferencedAttribute((ArtifactId)art, (AttributeTypeId)AtsAttributeTypes.ActionableItemReference, artifactId);
        }
        Collection collection = services.getAttributeResolver().getAttributes((ArtifactId)art, (AttributeTypeId)ActionableItem);
        LinkedList<String> currentAiGuidIds = new LinkedList<String>();
        for (IAttribute aiRefAttr : collection) {
            currentAiGuidIds.add(aiRefAttr.getValue().toString());
        }
        LinkedList<String> neededAiGuidIds = new LinkedList<String>();
        Collection aiArts = services.getAttributeResolver().getAttributeValues((ArtifactId)art, (AttributeTypeId)AtsAttributeTypes.ActionableItemReference);
        for (Object obj : aiArts) {
            IAtsActionableItem ai = null;
            ai = obj instanceof ArtifactId ? (IAtsActionableItem)services.getConfigItem((ArtifactId)obj) : (IAtsActionableItem)services.getConfigItem(Long.valueOf((String)obj));
            if (ai == null) {
                services.getLogger().error("AI not found for id " + obj + " for art " + art.toStringWithId(), new Object[0]);
                continue;
            }
            if (currentAiGuidIds.contains(ai.getStoreObject().getGuid())) continue;
            neededAiGuidIds.add((String)ai.getStoreObject().getGuid());
        }
        for (String guid : neededAiGuidIds) {
            changes.addAttribute((ArtifactId)art, (AttributeTypeId)ActionableItem, (Object)guid);
        }
    }

    public static void convertTeamDefinitionIfNeeded(IAtsChangeSet changes, ArtifactToken art, IAtsServices services) {
        ArtifactToken artifact;
        String teamDefGuid;
        String teamDefId = services.getAttributeResolver().getSoleAttributeValueAsString((ArtifactId)art, (AttributeTypeId)AtsAttributeTypes.TeamDefinitionReference, null);
        if (!Strings.isNumeric((String)teamDefId) && Strings.isValid((String)(teamDefGuid = (String)services.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeId)TeamDefinition, (Object)"")))) {
            IAtsTeamDefinition teamDef = (IAtsTeamDefinition)services.getConfigItem(teamDefGuid);
            changes.addArtifactReferencedAttribute((ArtifactId)art, (AttributeTypeId)AtsAttributeTypes.TeamDefinitionReference, (ArtifactId)teamDef.getStoreObject());
        }
        if (!Strings.isValid((String)(teamDefGuid = (String)services.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeId)TeamDefinition, (Object)""))) && Strings.isNumeric((String)(teamDefId = services.getAttributeResolver().getSoleAttributeValueAsString((ArtifactId)art, (AttributeTypeId)AtsAttributeTypes.TeamDefinitionReference, null))) && (artifact = services.getArtifact(Long.valueOf(teamDefId))) != null) {
            changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeId)TeamDefinition, artifact.getGuid());
        }
    }
}

