/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsUtilCore {
    public static final double DEFAULT_HOURS_PER_WORK_DAY = 8.0;
    public static final String DEFAULT_ATS_ID_VALUE = "0";
    public static final String USER_CREATION_DISABLED = "UserCreationDisabled2";
    public static final String ATS_CONFIG_ACTION_URL_KEY = "ActionUrl";
    public static final String ATS_DEFAULT_ACTION_URL = "/ats/ui/action/UUID";
    private static Map<Long, String> uuidToGuidMap = new HashMap<Long, String>(50);
    private static Map<String, Long> guidToUuidMap = new HashMap<String, Long>(50);

    public static List<String> toGuids(Collection<? extends IAtsObject> atsObjects) {
        ArrayList<String> guids = new ArrayList<String>(atsObjects.size());
        for (IAtsObject iAtsObject : atsObjects) {
            guids.add(AtsUtilCore.getGuid(iAtsObject));
        }
        return guids;
    }

    public static boolean isInTest() {
        return Boolean.valueOf(System.getProperty("osee.isInTest"));
    }

    public static String doubleToI18nString(double d) {
        return AtsUtilCore.doubleToI18nString(d, false);
    }

    public static String doubleToI18nString(double d, boolean blankIfZero) {
        if (blankIfZero && d == 0.0) {
            return "";
        }
        if (d == 0.0) {
            return "0.00";
        }
        return String.format("%4.2f", d);
    }

    public static String getGuid(IAtsObject atsObject) {
        String guid = uuidToGuidMap.get(atsObject.getId());
        if (!Strings.isValid((String)guid) && atsObject.getStoreObject() != null) {
            guid = (String)atsObject.getStoreObject().getGuid();
        }
        return guid;
    }

    public static String getGuid(Long uuid) {
        return uuidToGuidMap.get(uuid);
    }

    public static void putUuidToGuid(String guid, IAtsObject atsObject) {
        uuidToGuidMap.put(atsObject.getId(), guid);
        guidToUuidMap.put(guid, atsObject.getId());
    }

    public static Long getUuidFromGuid(String guid) {
        return guidToUuidMap.get(guid);
    }

    public static Dictionary<String, ?> hashTable(String key, String value) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(key, value);
        return table;
    }

    public static String getActionUrl(String atsIdOrUuid, IAtsServices services) {
        return AtsUtilCore.getActionUrl(atsIdOrUuid, ATS_DEFAULT_ACTION_URL, services);
    }

    public static String getActionUrl(String atsIdOrUuid, String defaultUrl, IAtsServices services) {
        String actionUrl = AtsUtilCore.getBaseActionUiUrl(defaultUrl, services);
        actionUrl = actionUrl.replaceFirst("UUID", atsIdOrUuid);
        return actionUrl;
    }

    public static String getBaseActionUiUrl(String defaultUrl, IAtsServices services) {
        String actionUrl = services.getConfigValue(ATS_CONFIG_ACTION_URL_KEY);
        if (!Strings.isValid((String)actionUrl)) {
            actionUrl = defaultUrl;
        }
        return actionUrl;
    }
}

